<?php
/**
 * @var $cases \Modules\Main\Entities\CCase[]
*/
?>


<?php $__env->startSection('page-title',  $page['seo_title']); ?>
<?php $__env->startSection('keywords',    $page['seo_keywords']); ?>
<?php $__env->startSection('description', $page['seo_description']); ?>

<?php $__env->startSection('content'); ?>


    <main class="page__main _full">
        <div class="slider">
            <div class="slider__container js-home-slider swiper-container">
                <div class="slider__inner swiper-wrapper">
                    <?php $__currentLoopData = $cases; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $case): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="slider__slide swiper-slide">
                        <div class="slider__header">
                            <div class="slider__bg" style="background-image: url(<?php echo e(getImagePath($case->image, 400, 450, 'crop')); ?>)"></div>
                            <div class="slider__info">
                                <div class="slider__inner inner">
                                    <div class="slider-number">
                                        <span class="slider-number__big">#01</span>
                                        <span class="slider-number__min">/<?php echo e($cases->count() < 10 ? '0' : ''); ?><?php echo e($cases->count()); ?></span>
                                    </div>
                                    <a href="<?php echo e(route('case.show', ['slug' => $case->slug], false)); ?>" class="slider__title">
                                        <?php echo e($case->title); ?>

                                    </a>
                                    <div class="slider__more-box">
                                        <a href="<?php echo e(route('case.show', ['slug' => $case->slug], false)); ?>" class="slider__more">ПОДРОБНЕЕ</a>
                                    </div>
                                </div>
                                <button type="button" class="slider-arrow__next js-home-slider-next"></button>
                            </div>
                            <?php if($case->video): ?>
                                <a href="<?php echo e($case->video); ?>" data-fancybox class="slider__video"></a>
                            <?php endif; ?>
                        </div>
                        <div class="slider__wrap">
                            <div class="slider__content">
                                <div class="slider__inner inner">
                                    <div class="slider-info">
                                        <div class="slider-info__inner">
                                            <div class="slider-info__wrapper">
                                                <?php if($case->brand): ?>
                                                <div class="slider-info__box">
                                                    <div class="slider-info__name">БРЕНД:</div>
                                                    <div class="slider-info__value"><?php echo e($case->brand); ?></div>
                                                </div>
                                                <?php endif; ?>
                                                <?php if($case->agency): ?>
                                                <div class="slider-info__box">
                                                    <div class="slider-info__name">АГЕНТСТВО:</div>
                                                    <div class="slider-info__value"><?php echo e($case->agency); ?></div>
                                                </div>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="slider-tags">
                                        <div class="slider-tags__wrapper">
                                            <?php $__currentLoopData = $case->tags; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tag): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <a href="#" class="slider-tags__box">#<?php echo e($tag->title); ?></a>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="slider__footer">
                                <div class="slider__inner inner">
                                    <div class="slider-pagination">
                                        <div class="slider-pagination__box">01</div>
                                        <div class="slider-pagination__slider swiper-pagination js-home-slider-pagination"></div>
                                        <div class="slider-pagination__box"><?php echo e($cases->count() < 10 ? '0' : ''); ?><?php echo e($cases->count()); ?></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    </main>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/resources/mobile/index.blade.php ENDPATH**/ ?>