<?php
/**
 * @var $case \Modules\Main\Entities\CCase
*/
?>


<?php $__env->startSection('page-title',  $case->title); ?>
<?php $__env->startSection('keywords',    ''); ?>
<?php $__env->startSection('description', ''); ?>

<?php $__env->startSection('content'); ?>

    <main class="page__main">
        <div class="page__content">
            <div class="page__inner inner">
                <div class="page__back back">
                    <a href="<?php echo e(route('cases')); ?>" class="back__link">НАЗАД</a>
                </div>
                <div class="post">
                    <div class="post__img">
                        <img src="<?php echo e(getImagePath($case->image, 400, 450, 'crop')); ?>" alt="">
                        <div class="post__status">
                            <img src="/mobile/img/heart.svg" alt="">
                        </div>
                        <div class="post__info">
                            <div class="post__name">
                                <?php echo e($case->title); ?>

                            </div>
                            <div class="post-tags">
                                <div class="post-tags__wrapper">
                                    <?php $__currentLoopData = $case->tags; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tag): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <a class="post-tags__box" href="#">#<?php echo e($tag->title); ?></a>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="post-params">
                        <div class="post-params__inner">
                            <div class="post-params__wrapper flex flex--wrap w-100">
                                <?php if($case->brand): ?>
                                <div class="post-params__box w-50">
                                    <div class="post-params__item">
                                        <div class="post-params__name">БРЕНД:</div>
                                        <div class="post-params__value"><?php echo e($case->brand); ?></div>
                                    </div>
                                </div>
                                <?php endif; ?>
                                <?php if($case->agency): ?>
                                <div class="post-params__box w-50">
                                    <div class="post-params__item">
                                        <div class="post-params__name">КЕЙС:</div>
                                        <div class="post-params__value"><?php echo e($case->agency); ?></div>
                                    </div>
                                </div>
                                <?php endif; ?>
                                <?php if($case->anons): ?>
                                <div class="post-params__box w-100">
                                    <div class="post-params__item">
                                        <div class="post-params__name">СУТЬ:</div>
                                        <div class="post-params__value">
                                            <?php echo $case->anons; ?>

                                        </div>
                                    </div>
                                </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>

                    <?php $__currentLoopData = $case->blocks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $block): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                        <?php switch($block->type):

                            case (\Modules\Main\Entities\Block::TYPE_SIMPLE_TEXT): ?>

                            <div class="typography">
                                <h2><?php echo e($block->title); ?></h2>
                                <p><?php echo $block->content1; ?></p>
                            </div>

                            <?php break; ?>

                            <?php case (\Modules\Main\Entities\Block::TYPE_TASK_DECISION): ?>
                            <div class="typography">
                                <span class="name">ЗАДАЧА:</span>
                                <?php echo $block->content1; ?>

                            </div>
                            <div class="typography">
                                <span class="name">РЕШЕНИЕ:</span>
                                <h2><?php echo e($block->title); ?></h2>
                                <?php echo $block->content2; ?>

                            </div>
                            <?php break; ?>

                            <?php case (\Modules\Main\Entities\Block::TYPE_RESULT): ?>
                            <div class="typography">
                                <span class="name">РЕЗУЛЬТАТ:</span>
                                <h2><?php echo e($block->title); ?></h2>
                                <p><?php echo $block->content1; ?></p>
                            </div>
                            <?php break; ?>

                            <?php case (\Modules\Main\Entities\Block::TYPE_GALLERY): ?>
                            <div class="post-slider">
                                <div class="post-slider__container js-slider-easy swiper-container">
                                    <div class="post-slider__wrapper swiper-wrapper">
                                        <?php $__currentLoopData = $block->images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="post-slider__box swiper-slide">
                                            <div class="post-slider__item">
                                                <img src="<?php echo e(getImagePath($image->image, 1440, 620, 'crop')); ?>" alt="">
                                            </div>
                                        </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                    <div class="post-slider__arrow">
                                        <button type="button" class="post-slider__arrow-item _prev js-slider-easy-prev"></button>
                                        <button type="button" class="post-slider__arrow-item _next js-slider-easy-next"></button>
                                    </div>
                                </div>
                            </div>

                            <?php break; ?>

                            <?php case (\Modules\Main\Entities\Block::TYPE_VIDEO): ?>
                            <div class="post-video">
                                <a href="<?php echo e($block->video); ?>" data-fancybox="video" class="post-video__link">
                                    <?php if($block->image): ?>
                                    <img src="<?php echo e(getImagePath($block->image)); ?>" alt="">
                                    <?php endif; ?>
                                </a>
                            </div>
                            <?php break; ?>

                        <?php endswitch; ?>

                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                </div>
                <div class="c-nav">
                    <div class="c-nav__inner">
                        <div class="c-nav__wrapper">
                            <div class="c-nav__box">
                                <?php if($case->previous()): ?>
                                <a href="<?php echo e(route('case.show', ['slug' => $case->previous()->slug])); ?>" class="c-nav__link _prev">ПРЕДЫДУЩИЙ КЕЙС</a>
                                <?php endif; ?>
                            </div>
                            <div class="c-nav__box">
                                <?php if($case->next()): ?>
                                <a href="<?php echo e(route('case.show', ['slug' => $case->next()->slug])); ?>" class="c-nav__link _next">СЛЕДУЮЩИЙ КЕЙС</a>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </main>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/resources/mobile/cases_one.blade.php ENDPATH**/ ?>