<?php
/**
 * @var $page[]
*/
?>


<?php $__env->startSection('page-title',  $page['seo_title']); ?>
<?php $__env->startSection('keywords',    $page['seo_keywords']); ?>
<?php $__env->startSection('description', $page['seo_description']); ?>
<?php $__env->startSection('body-class',  'maps'); ?>

<?php $__env->startSection('content'); ?>

    <div class="page-maps">
        <div class="page-maps--wrapp">
            <div class="contacts">
                <dl class="col">
                    <dt>АДРЕС:</dt>
                    <dd><?php echo nl2br($page['address']); ?></dd>
                </dl>
                <a href="#" class="bt" data-fancybox="inline" data-src="#address" href="javascript:;">КАК ДОБРАТЬСЯ</a>
                <dl class="col">
                    <dt>Телефон:</dt>
                    <dd>
                        <a href="tel:<?php echo e(preg_replace('/\D\+/', '', $page['phone1'])); ?>"><?php echo e($page['phone1']); ?></a>
                        <a href="tel:<?php echo e(preg_replace('/\D\+/', '', $page['phone2'])); ?>"><?php echo e($page['phone2']); ?></a>
                    </dd>
                </dl>
                <div class="box">
                    <?php if($page['email_tender']): ?>
                    <dl class="col2">
                        <dt>Пригласить в тендер</dt>
                        <dd><a href="mailto:<?php echo e($page['email_tender']); ?>" class="mail"><?php echo e($page['email_tender']); ?></a></dd>
                    </dl>
                    <?php endif; ?>
                    <?php if($page['email_common']): ?>
                    <dl class="col2">
                        <dt>По общим вопросам</dt>
                        <dd><a href="mailto:<?php echo e($page['email_common']); ?>" class="mail"><?php echo e($page['email_common']); ?></a></dd>
                    </dl>
                    <?php endif; ?>
                    <?php if($page['email_hr']): ?>
                    <dl class="col2">
                        <dt>Хочу работать у вас</dt>
                        <dd><a href="mailto:<?php echo e($page['email_hr']); ?>" class="mail"><?php echo e($page['email_hr']); ?></a></dd>
                    </dl>
                    <?php endif; ?>
                    <?php if($page['email_pr']): ?>
                    <dl class="col2">
                        <dt>По вопросам PR и спикерства</dt>
                        <dd><a href="mailto:<?php echo e($page['email_pr']); ?>" class="mail"><?php echo e($page['email_pr']); ?></a></dd>
                    </dl>
                    <?php endif; ?>
                </div>
            </div>
            <div class="mapContainer">
                <div class="map" id="map" data-x="<?php echo e(trim($coordinates[0])); ?>" data-y="<?php echo e(trim($coordinates[1])); ?>">
                </div>
            </div>
        </div>
    </div>
    <div id="address" class="fancy" style="display: none;">
        <p class="title">КАК ДОБРАТЬСЯ:</p>
        <?php echo $page['route']; ?>

    </div>

<?php $__env->stopSection(); ?>
<script src="https://api-maps.yandex.ru/2.1/?lang=ru_RU" type="text/javascript"></script>
<?php $__env->startPush('scripts'); ?>

<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/new-test.movie-group.ru/resources/views/contacts.blade.php ENDPATH**/ ?>