<?php
/**
 * @var $cases \Modules\Main\Entities\CCase[]
*/
?>


<?php $__env->startSection('page-title',  'Кейсы'); ?>
<?php $__env->startSection('keywords',    ''); ?>
<?php $__env->startSection('description', ''); ?>

<?php $__env->startSection('content'); ?>

    <main class="page__main _full">
        <div class="slider inner">
            <div class="slider__container js-home-slider swiper-container">
                <div class="slider__inner swiper-wrapper">
                    <?php $__currentLoopData = $cases; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $case): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="slider__slide swiper-slide">
                        <div class="slider__header _min">
                            <a href="<?php echo e(route('case.show', ['slug' => $case->slug], false)); ?>" class="slider__bg" style="background-image: url(<?php echo e(getImagePath($case->image, 400, 450, 'crop')); ?>)"></a>
                            <div class="slider__status">
                                <img src="/mobile/img/heart.svg" alt="">
                            </div>
                            <a href="<?php echo e(route('case.show', ['slug' => $case->slug], false)); ?>" class="slider__full-btn">СМОТРЕТЬ КЕЙС</a>
                            <?php if($case->video): ?>
                                <a href="<?php echo e($case->video); ?>" data-fancybox class="slider__video"></a>
                            <?php endif; ?>
                        </div>
                        <div class="slider__wrap">
                            <div class="slider__content">
                                <div class="slider__inner">
                                    <div class="slider-info _arrow">
                                        <button type="button" class="slider-arrow__next js-home-slider-next"></button>
                                        <div class="slider-info__inner">
                                            <div class="slider-info__wrapper">
                                                <?php if($case->title): ?>
                                                <div class="slider-info__box">
                                                    <div class="slider-info__name">КЕЙС:</div>
                                                    <div class="slider-info__value"><?php echo e($case->title); ?></div>
                                                </div>
                                                <?php endif; ?>
                                                <?php if($case->brand): ?>
                                                <div class="slider-info__box">
                                                    <div class="slider-info__name">БРЕНД:</div>
                                                    <div class="slider-info__value"><?php echo e($case->brand); ?></div>
                                                </div>
                                                <?php endif; ?>
                                                <?php if($case->agency): ?>
                                                <div class="slider-info__box">
                                                    <div class="slider-info__name">АГЕНТСТВО:</div>
                                                    <div class="slider-info__value"><?php echo e($case->agency); ?></div>
                                                </div>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="slider-tags">
                                        <div class="slider-tags__wrapper">
                                            <?php $__currentLoopData = $case->tags; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tag): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <a href="#" class="slider-tags__box">#<?php echo e($tag->title); ?></a>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="slider__footer">
                                <div class="slider__inner">
                                    <div class="slider-pagination">
                                        <div class="slider-pagination__box">01</div>
                                        <div class="slider-pagination__slider swiper-pagination js-home-slider-pagination"></div>
                                        <div class="slider-pagination__box"><?php echo e($cases->count() < 10 ? '0' : ''); ?><?php echo e($cases->count()); ?></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    </main>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/resources/mobile/cases.blade.php ENDPATH**/ ?>