<?php
/**
 * @var $case \Modules\Main\Entities\CCase
 */

?>



<?php $__env->startSection('page-title',  $case->title); ?>
<?php $__env->startSection('keywords',    ''); ?>
<?php $__env->startSection('description', ''); ?>
<?php $__env->startSection('header-class', $case->luminance ? ' headerBlue' : ''); ?>

<?php $__env->startSection('content'); ?>

<div class="case case4 case--active" data-slide="4">
    <?php if(!$ajax): ?>
        <div class="mainImgCase<?php echo e($case->luminance ? ' imgLight' : ''); ?>" style="background-image: url(<?php echo e(getImagePath($case->image, 900, 1200, 'crop')); ?>)"></div>
    <?php endif; ?>
    <div class="case__descr">
        <?php if(!$ajax): ?>
            <a href="/cases/" class="case__back">
                <img class="case__back-icon" src="/images/general/arrow-left.svg" alt=""><span class="case__back-text">НАЗАД</span>
            </a>
        <?php else: ?>
            <button class="case__back">
                <img class="case__back-icon" src="/images/general/arrow-left.svg" alt=""><span class="case__back-text">НАЗАД</span>
            </button>
        <?php endif; ?>
        <h1 class="case__title"><?php echo e($case->title); ?></h1>
        <div class="case__tags">
            <?php $__currentLoopData = $case->tags; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tag): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <a class="case__tags-item" href="#">#<?php echo e($tag->title); ?></a>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
        <?php if($case->brand): ?>
        <div class="case__label">
            <div class="case__label-caption">БРЕНД:</div>
            <div class="case__label-text"><?php echo e($case->brand); ?></div>
        </div>
        <?php endif; ?>
        <?php if($case->agency): ?>
        <div class="case__label">
            <div class="case__label-caption">АГЕНТСТВО:</div>
            <div class="case__label-text"><?php echo e($case->agency); ?></div>
        </div>
        <?php endif; ?>
        <?php if($case->anons): ?>
        <div class="case__label case__label--row-text">
            <div class="case__label-caption">СУТЬ:</div>
            <div class="case__label-row-text">
                <?php echo $case->anons; ?>

            </div>
        </div>
        <?php endif; ?>
        <button class="case__more">
            <img class="case__more-icon" src="/images/general/arrow-left.svg" alt="">
            <div class="case__more-text">ПОДРОБНЕЕ</div>
        </button>
    </div>
    <img class="case__heart" src="" data-ajax-url="/images/general/heart.svg" alt="">

    <?php $__currentLoopData = $case->blocks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $block): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

        <?php switch($block->type):

            case (\Modules\Main\Entities\Block::TYPE_SIMPLE_TEXT): ?>

            <div class="case__paragraph">
                <h3 class="case__paragraph-title animatedOpacity"><?php echo e($block->title); ?></h3>
                <div class="case__paragraph-text animatedOpacity"><?php echo $block->content1; ?></div>
            </div>

            <?php break; ?>

            <?php case (\Modules\Main\Entities\Block::TYPE_TASK_DECISION): ?>
            <div class="case__paragraph-with-side animatedOpacity">
                <div class="case__paragraph-with-side-caption">ЗАДАЧА:</div>
                <div class="case__paragraph-with-side-right">
                    <div class="case__paragraph-with-side-text"><?php echo $block->content1; ?></div>
                </div>
            </div>
            <div class="case__paragraph-with-side animatedOpacity">
                <div class="case__paragraph-with-side-caption">РЕШЕНИЕ:</div>
                <div class="case__paragraph-with-side-right">
                    <div class="case__paragraph-with-side-title"><?php echo e($block->title); ?></div>
                    <div class="case__paragraph-with-side-text"><?php echo $block->content2; ?></div>
                </div>
            </div>
            <?php break; ?>

            <?php case (\Modules\Main\Entities\Block::TYPE_RESULT): ?>
            <div class="case__paragraph-with-side animatedOpacity">
                <div class="case__paragraph-with-side-caption">РЕЗУЛЬТАТ:</div>
                <div class="case__paragraph-with-side-right">
                    <div class="case__paragraph-with-side-title"><?php echo e($block->title); ?></div>
                    <div class="case__paragraph-with-side-text"><?php echo $block->content1; ?></div>
                </div>
            </div>
            <?php break; ?>

            <?php case (\Modules\Main\Entities\Block::TYPE_GALLERY): ?>
            <div class="case__slider animatedOpacity">
                <div class="case__slider-frame">
                    <?php $__currentLoopData = $block->images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="case__slider-item" style="background-image: url(<?php echo e(getImagePath($image->image, 1440, 620, 'crop')); ?>)"></div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
                <div class="case__slider-palatno"></div>
                <div class="case__slider-arrows">
                    <button class="case__slider-arrows-item case__slider-arrows-item--left">
                        <svg version="1.1" id="Слой_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 38.4 60.4" style="enable-background:new 0 0 38.4 60.4;" xml:space="preserve" class="case__slider-arrows-svg">
                    <style type="text/css">
                        .st13 {
                            clip-path: url(#SVGID_4_1l);
                            fill: #d9ef76;
                        }
                    </style>
                            <g id="group">
                                <path fill="#fff" d="M0.7,0l28.4,30.9L0.7,60.4L0,59.7l27.7-28.9L0,0.7L0.7,0z" class="arrow2" />
                                <g>
                                    <defs>
                                        <path id="SVGID_3_1l" class="clip2" d="M1.4,0.7h9.4l27.7,30.1L10.7,59.7H1.4l27.7-28.9L1.4,0.7z" />
                                    </defs>
                                    <clipPath id="SVGID_4_1l">
                                        <use xlink:href="#SVGID_3_1l" />
                                    </clipPath>
                                    <path class="st13" d="M1.4,0.7h9.4l27.7,30.1L10.7,59.7H1.4l27.7-28.9L1.4,0.7z" />
                                </g>
                            </g>
                </svg>

                    </button>
                    <button class="case__slider-arrows-item case__slider-arrows-item--right">
                        <svg version="1.1" id="Слой_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 38.4 60.4" style="enable-background:new 0 0 38.4 60.4;" xml:space="preserve" class="case__slider-arrows-svg">
                    <style type="text/css">
                        .st14 {
                            clip-path: url(#SVGID_5_1r);
                            fill: #d9ef76;
                        }
                    </style>
                            <g id="group">
                                <path fill="#fff" d="M0.7,0l28.4,30.9L0.7,60.4L0,59.7l27.7-28.9L0,0.7L0.7,0z" class="arrow2" />
                                <g>
                                    <defs>
                                        <path id="SVGID_4_1r" class="clip2" d="M1.4,0.7h9.4l27.7,30.1L10.7,59.7H1.4l27.7-28.9L1.4,0.7z" />
                                    </defs>
                                    <clipPath id="SVGID_5_1r">
                                        <use xlink:href="#SVGID_4_1r" />
                                    </clipPath>
                                    <path class="st14" d="M1.4,0.7h9.4l27.7,30.1L10.7,59.7H1.4l27.7-28.9L1.4,0.7z" />
                                </g>
                            </g>
                </svg>

                    </button>
                </div>
            </div>
            <?php break; ?>

            <?php case (\Modules\Main\Entities\Block::TYPE_VIDEO): ?>
            <div class="case__video animatedOpacity" style="background-image: url(<?php echo e($block->image ? getImagePath($block->image) : ''); ?>)">
                <div class="case__video-frame"></div>
                <button class="case__video-button" data-video="<?php echo e($block->video); ?>">
                    <div class="case__video-button-icon"></div>
                </button>
            </div>
            <?php break; ?>

        <?php endswitch; ?>

    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    <div class="case__other-cases animatedOpacity">
        <?php if($case->previous()): ?>
        <a href="/cases/<?php echo e($case->previous()->slug); ?>" class="case__other-cases-item">
            <div class="case__other-cases-item-img"  style="background-image: url(<?php echo e(getImagePath($case->previous()->image, 600, 600, 'crop')); ?>)"></div>
            <div class="case__other-cases-item-text"><?php echo e($case->previous()->brand); ?></div>
            <div class="case__other-cases-item-button">СМОТРЕТЬ КЕЙС</div>
        </a>
        <?php endif; ?>

        <?php if($case->next()): ?>
        <a href="/cases/<?php echo e($case->next()->slug); ?>" class="case__other-cases-item">
            <div class="case__other-cases-item-img"  style="background-image: url(<?php echo e(getImagePath($case->next()->image, 600, 600, 'crop')); ?>)"></div>
            <div class="case__other-cases-item-text"><?php echo e($case->next()->brand); ?></div>
            <div class="case__other-cases-item-button">СМОТРЕТЬ КЕЙС</div>
        </a>
        <?php endif; ?>
    </div>
</div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make($ajax ? 'layouts.modal' : 'layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/resources/views/cases_one.blade.php ENDPATH**/ ?>