<?php
/**
 * @var $page[]
 */
?>


<?php $__env->startSection('page-title',  $page['seo_title']); ?>
<?php $__env->startSection('keywords',    $page['seo_keywords']); ?>
<?php $__env->startSection('description', $page['seo_description']); ?>

<?php $__env->startSection('content'); ?>

    <main class="page__main">
        <div class="contacts js-animate">
            <div class="contacts__wrap">
                <div class="contacts__inner inner">
                    <div class="contacts-box js-animate">
                        <div class="contacts-box__name">АДРЕС:</div>
                        <div class="contacts-box__desc">
                            <p><?php echo nl2br($page['address']); ?></p>
                        </div>
                        <div class="contacts-box__btn-box">
                            <button type="button" class="contacts-box__btn btn btn--type-1 js-modal-link" data-link="#contacts-box">КАК ДОБРАТЬСЯ</button>
                        </div>
                    </div>
                    <div class="contacts-box js-animate">
                        <div class="contacts-box__name">Телефон:</div>
                        <div class="contacts-box__phone-box">
                            <a href="tel:<?php echo e(preg_replace('/\D\+/', '', $page['phone1'])); ?>" class="contacts-box__phone"><?php echo e($page['phone1']); ?></a>
                            <a href="tel:<?php echo e(preg_replace('/\D\+/', '', $page['phone2'])); ?>" class="contacts-box__phone"><?php echo e($page['phone2']); ?></a>
                        </div>
                    </div>
                    <div class="contacts-box js-animate">
                        <div class="contacts-box-list">
                            <?php if($page['email_tender']): ?>
                            <div class="contacts-box-list__box">
                                <div class="contacts-box-list__name">Пригласить в тендер</div>
                                <div class="contacts-box-list__desc">
                                    <a href="mailto:welcome@movie-group.ru"><?php echo e($page['email_tender']); ?></a>
                                </div>
                            </div>
                            <?php endif; ?>
                            <?php if($page['email_common']): ?>
                            <div class="contacts-box-list__box">
                                <div class="contacts-box-list__name">По общим вопросам</div>
                                <div class="contacts-box-list__desc">
                                    <a href="mailto:reception@movie-group.ru"><?php echo e($page['email_common']); ?></a>
                                </div>
                            </div>
                            <?php endif; ?>
                            <?php if($page['email_hr']): ?>
                            <div class="contacts-box-list__box">
                                <div class="contacts-box-list__name">Хочу работать у вас</div>
                                <div class="contacts-box-list__desc">
                                    <a href="mailto:hr@movie-group.ru"><?php echo e($page['email_hr']); ?></a>
                                </div>
                            </div>
                            <?php endif; ?>
                            <?php if($page['email_pr']): ?>
                            <div class="contacts-box-list__box">
                                <div class="contacts-box-list__name">По вопросам PR и спикерства</div>
                                <div class="contacts-box-list__desc">
                                    <a href="mailto:pr@movie-group.ru"><?php echo e($page['email_pr']); ?></a>
                                </div>
                            </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
            <div class="contacts__map-box">
                <canvas id="c-wave" class="contacts__map-wave"></canvas>
                <div class="contacts__map js-contacts-map" id="contacts-map" data-x="<?php echo e(trim($coordinates[0])); ?>" data-y="<?php echo e(trim($coordinates[1])); ?>"></div>
            </div>
            <script src="https://api-maps.yandex.ru/2.1/?lang=ru_RU" type="text/javascript"></script>
        </div>
    </main>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('modal'); ?>
    <div id="contacts-box" class="modal js-modal">
        <div class="modal__close-box">
            <button type="button" class="modal__close js-modal-close"></button>
        </div>
        <div class="modal-content">
            <div class="modal-content__wrap">
                <div class="modal-content__title">КАК ДОБРАТЬСЯ:</div>
                <div class="modal-contacts">
                    <div class="modal-contacts__box">
                        <div class="modal-contacts__desc">
                            <?php echo $page['route']; ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
	

<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/resources/mobile/contacts.blade.php ENDPATH**/ ?>