<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

function getCurrentLocale()
{
    $segment = request()->segment(1);

    if (in_array($segment, config('translatable.locales'))) {

        if ($segment != config('app.fallback_locale')) return $segment;
    }
    return null;
}


Route::group(['middleware' => ['web'], 'prefix' => getCurrentLocale()], function(){

    Route::get('/', 'IndexController@index')->name('home');
    Route::get('/about', 'IndexController@about')->name('about');
    Route::get('/cases', 'IndexController@cases')->name('cases');
    Route::get('/cases/{slug}', 'IndexController@case')->where('slug', '([A-z\d-_.]+)?')->name('case.show');
    Route::get('/expertise', 'IndexController@expertise')->name('expertise');
    Route::get('/news', 'IndexController@news')->name('news');
    Route::get('/news/{slug}', 'IndexController@news_one')->where('slug', '([A-z\d-_.]+)?')->name('news.show');
    Route::get('/agencies', 'IndexController@agencies')->name('agencies');
    Route::get('/clients', 'IndexController@clients')->name('clients');
    Route::get('/contacts', 'IndexController@contacts')->name('contacts');

});
