<header class="header @yield('header-class', '')">
    <div class="header__inner">
        <a class="header__logo" href="/">
            <img class="header__logo-img" alt="" width="96" data-ajax-url="/images/general/logo.svg">
        </a>
        <nav class="header__nav">
            <ul class="header__nav-list">
                <li class="header__nav-item"><a class="header__nav-link" href="{{ route('cases') }}">КЕЙСЫ</a>
                </li>
                <li class="header__nav-item"><a class="header__nav-link" href="{{ route('expertise') }}">ЭКСПЕРТИЗЫ</a>
                </li>
                <li class="header__nav-item"><a class="header__nav-link" href="{{ route('news') }}">НОВОСТИ</a>
                </li>
                @if( app('settings')->get('blog_link') )
                <li class="header__nav-item"><a class="header__nav-link" target="_blank" href="{{ app('settings')->get('blog_link') }}">БЛОГ</a>
                </li>
                @endif
            </ul>
        </nav>
        <a href="/uploads/{{ app('settings')->get('brief') }}" target="_blank" class="header__brief header__brief--blue">BRIEF.ME</a>
        <button class="header__button">
            <div class="header__button-inner">
                <div></div>
                <div></div>
                <div></div>
            </div>
        </button>
    </div>
</header>
<menu class="menu">
    <a class="menu__logo" href="/">
        <img class="menu__logo-img" alt="" width="96" data-ajax-url="/images/general/logo.svg">
    </a>
    <button class="menu__close-button">
        <img class="menu__close-button-img" alt="" data-ajax-url="/images/general/x.svg">
    </button>
    <div class="menu__grafic">
        <div class="menu__grafic-video">
            <video class="menu__grafic-video-frame" width="100%" height="100%" data-ajax-url="{{ app('settings')->get('menu_video') ? '/uploads/'.app('settings')->get('menu_video') : '/video/menu__video.mp4' }}" muted loop></video>
        </div>
        <div class="menu__grafic-col"></div>
        <div class="menu__grafic-col"></div>
        <div class="menu__grafic-col"></div>
        <div class="menu__grafic-col"></div>
        <div class="menu__grafic-col"></div>
        <div class="menu__grafic-col"></div>
        <div class="menu__grafic-col"></div>
    </div>
    <ul class="menu__list">
        <li class="menu__item">
            <a class="menu__link" href="{{ route('about') }}"> <span class="menu__link-text">О НАС</span>
            </a>
        </li>
        <li class="menu__item">
            <a class="menu__link" href="{{ route('cases') }}"> <span class="menu__link-text">КЕЙСЫ</span>
            </a>
        </li>
        <li class="menu__item">
            <a class="menu__link" href="{{ route('expertise') }}"> <span class="menu__link-text">ЭКСПЕРТИЗЫ</span>
            </a>
        </li>
        <li class="menu__item">
            <a class="menu__link" href="{{ route('news') }}"> <span class="menu__link-text">НОВОСТИ</span>
            </a>
        </li>
        <li class="menu__item">
            <a class="menu__link" href="{{ route('agencies') }}"> <span class="menu__link-text">АГЕНТСТВА</span>
            </a>
        </li>
        <li class="menu__item">
            <a class="menu__link" href="{{ route('clients') }}"><span class="menu__link-text">КЛИЕНТЫ</span>
            </a>
        </li>
        <li class="menu__item">
            <a class="menu__link" href="{{ route('contacts') }}"> <span class="menu__link-text">КОНТАКТЫ</span>
            </a>
        </li>
    </ul>
</menu>