<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    @include('layouts.particles.head')
</head>
<body class="page @yield('body-class')">

    <div class="page__wrapper">
        <div class="wrapper-for-canvas wrapper-for-canvas--page-clients">
            <canvas class="canvas" id="backgroundCanvas"></canvas>
        </div>

        @include('layouts.particles.menu_top')
        @include('layouts.particles.footer')
        @yield('content')

    </div>
   
    <div class="preloader {{ Session::get('hidePreloader')===1 ? 'preloader--display-none' : '' }}">
        <div class="preloader__frame">
            <video class="preloader__video" width="100%" height="100%" data-ajax-url="/video/preloader__video.mp4" muted></video>
        </div>
    </div>

    <div class="preloaderInside">
        <i></i><i></i><i></i><i></i><i></i><i></i><i></i>
    </div>

</body>
<script src="/js/jquery-1.12.4.min.js"></script>
<script src="/js/svg-sprite.js"></script>
<script src="/js/wow.js"></script>
<script src="/js/jquery.fancybox.min.js"></script>
<script src="/js/TweenMax.min.js"></script>
<script src="/js/EasePack.min.js"></script>
<script src="/js/MorphSVGPlugin.min.js"></script>
<script src="/js/base.js"></script>

@stack('scripts')

{!! app('settings')->get('counters') !!}

@if(Session::has('screen_width'))

@endif

</html>