@extends('layouts.main')

@section('page-title',  $page['seo_title'])
@section('keywords',    $page['seo_keywords'])
@section('description', $page['seo_description'])

@section('content')

    <div class="page-home">
        <div class="page-home__slider">
            @php($i=0)
            @foreach($cases as $case)
                <div class="page-home__slider-item" data-pos="{{ $i<2 ? $i+1 : 'false'}}" style="background-image: url({{ getImagePath($case->image, 900, 1200, 'crop') }})" data-link="/cases/{{ $case->slug }}">
                    <a class="page-home__descr-more" href="{{ route('case.show', ['slug' => $case->slug], false) }}"></a>
                </div>
                @php($i++)
            @endforeach
        </div>
        <div class="page-home__arrows">
            <button class="page-home__arrows-item page-home__arrows-item--disabled page-home__arrows-item--left">
                <svg version="1.1" id="Слой_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 38.4 60.4" style="enable-background:new 0 0 38.4 60.4;" xml:space="preserve" class="page-cases__arrows-svg">
                            <style type="text/css">
                                .cst1 {
                                    clip-path: url(#cSVGID_2_);
                                    fill: #d9ef76;
                                }
                            </style>
                    <g id="group">
                        <path fill="#fff" d="M0.7,0l28.4,30.9L0.7,60.4L0,59.7l27.7-28.9L0,0.7L0.7,0z" class="arrow"></path>
                        <g>
                            <defs>
                                <path id="cSVGID_1_" class="clip" d="M1.4,0.7h9.4l27.7,30.1L10.7,59.7H1.4l27.7-28.9L1.4,0.7z" style="transform: translateX(10px);"></path>
                            </defs>
                            <clipPath id="cSVGID_2_">
                                <use xlink:href="#cSVGID_1_"></use>
                            </clipPath>
                            <path class="cst1" d="M1.4,0.7h9.4l27.7,30.1L10.7,59.7H1.4l27.7-28.9L1.4,0.7z"></path>
                        </g>
                    </g>
                        </svg>

            </button>
            <button class="page-home__arrows-item page-home__arrows-item--right">
                <svg version="1.1" id="Слой_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 38.4 60.4" style="enable-background:new 0 0 38.4 60.4;" xml:space="preserve" class="page-cases__arrows-svg">
                            <style type="text/css">
                                .cst2 {
                                    clip-path: url(#cSVGID_4_);
                                    fill: #d9ef76;
                                }
                            </style>
                    <g id="group">
                        <path fill="#fff" d="M0.7,0l28.4,30.9L0.7,60.4L0,59.7l27.7-28.9L0,0.7L0.7,0z" class="arrow" />
                        <g>
                            <defs>
                                <path id="cSVGID_3_" class="clip" d="M1.4,0.7h9.4l27.7,30.1L10.7,59.7H1.4l27.7-28.9L1.4,0.7z" style="transform: translateX(-10px);"/>
                            </defs>
                            <clipPath id="cSVGID_4_">
                                <use xlink:href="#cSVGID_3_" />
                            </clipPath>
                            <path class="cst2" d="M1.4,0.7h9.4l27.7,30.1L10.7,59.7H1.4l27.7-28.9L1.4,0.7z" />
                        </g>
                    </g>
                        </svg>
            </button>
        </div>
        <div class="page-home__pagination">
            <div class="page-home__pagination-counter"></div>
            <div class="page-home__pagination-indicator">
                <div class="page-home__pagination-caret"></div>
            </div>
            <div class="page-home__pagination-number"></div>
        </div>
        <div class="page-home__titles">
            @php($i=0)
            <?php

                $new_cases = $cases->all();
                $last_case = array_shift($new_cases);
                $new_cases[] = $last_case;

            ?>
            @foreach($new_cases as $case)
            <div class="page-home__titles-item {{ $i ? '' : 'page-home__titles-item--active' }}">
                @if($i<count($new_cases)-1)
                <p>{{ $case->splitTitle[0] }}</p>
                <p>{{ $case->splitTitle[1] }}</p>
                @endif
            </div>
            @php($i++)
            @endforeach
        </div>

        <div class="page-home__descr">
            @php($i=0)
            @foreach($cases as $case)
            <div class="page-home__descr-item {{ $i ? '' : 'page-home__descr-item--active' }}">
                <div class="page-home__descr-counter">
                    <div class="page-home__descr-counter-current"></div>
                    <div class="page-home__descr-counter-all"></div>
                </div>
                <div class="page-home__descr-title">
                    <svg class="page-home__descr-title-word1" xmlns="http://www.w3.org/2000/svg">
                        <defs>
                            <clipPath id="clip{{ $i }}">
                                <text class="page-home__descr-title-text " x="-0.5" y="86.5px">{{ $case->splitTitle[0] }}</text>
                                <text class="page-home__descr-title-text " x="0.5" y="86.5px">{{ $case->splitTitle[0] }}</text>
                                <text class="page-home__descr-title-text " x="0.5" y="87.5px">{{ $case->splitTitle[0] }}</text>
                                <text class="page-home__descr-title-text " x="-0.5" y="88px">{{ $case->splitTitle[0] }}</text>
                            </clipPath>
                        </defs>
                        <g>
                            <g clip-path="url(#clip{{ $i }})">
                                <!-- <rect class="page-home__descr-title-rect" x="0" y="0" width="100%" height="100%"></rect> -->
                                <rect class="page-home__descr-title-rect2" x="0" y="0" width="100%" height="100%"></rect>
                            </g>
                            <text class="page-home__descr-title-text" x="0" y="87px">{{ $case->splitTitle[0] }}</text>
                        </g>
                    </svg>
                    <svg class="page-home__descr-title-word2" xmlns="http://www.w3.org/2000/svg">
                        <defs>
                            <clipPath id="clip2{{ $i }}">
                                <text class="page-home__descr-title-text " x="-0.5" y="86.5px">{{ $case->splitTitle[1] }}</text>
                                <text class="page-home__descr-title-text " x="0.5" y="86.5px">{{ $case->splitTitle[1] }}</text>
                                <text class="page-home__descr-title-text " x="0.5" y="87.5px">{{ $case->splitTitle[1] }}</text>
                                <text class="page-home__descr-title-text " x="-0.5" y="88px">{{ $case->splitTitle[1] }}</text>
                            </clipPath>
                        </defs>
                        <g>
                            <g clip-path="url(#clip2{{ $i }})">
                                <rect class="page-home__descr-title-rect" x="0" y="0" width="100%" height="100%"></rect>
                                <rect class="page-home__descr-title-rect2" x="0" y="0" width="100%" height="100%"></rect>
                            </g>
                            <text class="page-home__descr-title-text" x="0" y="87px">{{ $case->splitTitle[1] }}</text>
                        </g>
                    </svg>
                </div>
                @if($case->brand)
                <div class="page-home__descr-label">
                    <div class="page-home__descr-label-caption">КЕЙС:</div>
                    <div class="page-home__descr-label-text">{{ $case->brand }}</div>
                </div>
                @endif
                @if($case->agency)
                <div class="page-home__descr-label">
                    <div class="page-home__descr-label-caption">АГЕНТСТВО:</div>
                    <div class="page-home__descr-label-text">{{ $case->agency }}</div>
                </div>
                @endif
                <div class="page-home__descr-tags">
                    @foreach($case->tags as $tag)
                        <div class="page-home__descr-tags-item">#{{ $tag->title }}</div>
                    @endforeach
                </div>
                <a class="page-home__descr-more" href="/cases/{{ $case->slug }}">ПОДРОБНЕЕ</a>
                @if($case->video)
                <div class="page-home__play-buttons">
                    <a data-fancybox="video" class="page-home__play-buttons-item" href="{{ $case->video }}">
                        <div class="page-home__play-buttons-item-icon"></div>
                    </a>
                </div>
                @endif
            </div>
            @php($i++)
            @endforeach
        </div>
        <div class="cases"></div>

    </div>

@endsection