<?php
/**
 * @var $page[]
*/
?>
@extends('layouts.main')

@section('page-title',  $page['seo_title'])
@section('keywords',    $page['seo_keywords'])
@section('description', $page['seo_description'])

@section('content')

    <div class="page-expertise">
        <div class="page-expertise--wrapp">

            <div class="page-expertise--container">
                <div class="item-box item-box--left">
                    <div class="item item--turquoise">
                        <a class="box">
                            <svg style="width: 63rem; height: 73rem" class="svgContainer">
                                <use xlink:href="#bg-turquoise"></use>
                            </svg>
                            <i class="before" data-id="#bg-turquoise"></i>
                            <svg class="circle-chart" viewBox="0 0 33.83098862 33.83098862" xmlns="http://www.w3.org/2000/svg">
                                <circle class="circle-chart__background" cx="16.9" cy="16.9" r="14.4"></circle>
                                <circle class="circle-chart__circle success-stroke" stroke-dasharray="67.8,100" cx="16.9" cy="16.9" r="14.4"></circle>
                            </svg>
                            <div class="text">
                                <p><span>{!! implode('</span></p><p><span>', explode("\r\n", $page['header_n1'])) !!}</span></p>
                            </div>
                            <div class="boxHidd">
                                <div class="textHide">
                                    <div class="title">
                                        <p>{!! implode('</p><p>', explode("\r\n", $page['header_n1'])) !!}</p>
                                    </div>
                                    <p>{!! implode('</p><p>', explode("\r\n", $page['text_n1'])) !!}</p>
                                </div>
                            </div>
                        </a>
                    </div>
                    <div class="item item--pink">
                        <a class="box">
                            <svg style="width: 74.31rem; height: 74.31rem;" class="svgContainer">
                                <use xlink:href="#bg-pink"></use>
                            </svg>
                            <i class="before" data-id="#bg-pink"></i>
                            <svg class="circle-chart" viewBox="0 0 33.83098862 33.83098862" xmlns="http://www.w3.org/2000/svg">
                                <circle class="circle-chart__background" cx="16.9" cy="16.9" r="14.4"></circle>
                                <circle class="circle-chart__circle success-stroke" stroke-dasharray="67.8,100" cx="16.9" cy="16.9" r="14.4"></circle>
                            </svg>
                            <div class="text">
                                <p><span>{!! implode('</span></p><p><span>', explode("\r\n", $page['header_n2'])) !!}</span></p>
                            </div>
                            <div class="boxHidd">
                                <div class="textHide">
                                    <div class="title">
                                        <p>{!! implode('</p><p>', explode("\r\n", $page['header_n2'])) !!}</p>
                                    </div>
                                    <p>{!! implode('</p><p>', explode("\r\n", $page['text_n2'])) !!}</p>
                                </div>
                            </div>
                        </a>
                    </div>
                </div>
                <div class="item-box item-box--right">
                    <div class="item item--orange">
                        <a class="box">
                            <svg style="width: 41.44rem; height: 45.06rem" class="svgContainer">
                                <use xlink:href="#bg-orange"></use>
                            </svg>
                            <i class="before" data-id="#bg-orange"></i>
                            <svg class="circle-chart" viewBox="0 0 33.83098862 33.83098862" xmlns="http://www.w3.org/2000/svg">
                                <circle class="circle-chart__background" cx="16.9" cy="16.9" r="14.4"></circle>
                                <circle class="circle-chart__circle success-stroke" stroke-dasharray="67.8,100" cx="16.9" cy="16.9" r="14.4"></circle>
                            </svg>
                            <div class="text">
                                <p><span>{!! implode('</span></p><p><span>', explode("\r\n", $page['header_n3'])) !!}</span></p>
                            </div>
                            <div class="boxHidd">
                                <div class="textHide exp-light">
                                    <div class="title exp-light">
                                        <p>{!! implode('</p><p>', explode("\r\n", $page['header_n3'])) !!}</p>
                                    </div>
                                    <p class="exp-light">{!! implode('</p><p class="exp-light">', explode("\r\n", $page['text_n3'])) !!}</p>
                                </div>
                            </div>
                        </a>
                    </div>
                    <div class="item item--purpure">
                        <a class="box">
                            <svg style="width: 57.06rem; height: 72.69rem" class="svgContainer">
                                <use xlink:href="#bg-purpure"></use>
                            </svg>
                            <i class="before" data-id="#bg-purpure"></i>
                            <svg class="circle-chart" viewBox="0 0 33.83098862 33.83098862" xmlns="http://www.w3.org/2000/svg">
                                <circle class="circle-chart__background" cx="16.9" cy="16.9" r="14.4"></circle>
                                <circle class="circle-chart__circle success-stroke" stroke-dasharray="67.8,100" cx="16.9" cy="16.9" r="14.4"></circle>
                            </svg>
                            <div class="text">
                                <p><span>{!! implode('</span></p><p><span>', explode("\r\n", $page['header_n4'])) !!}</span></p>
                            </div>
                            <div class="boxHidd">
                                <div class="textHide">
                                    <div class="title exp-light">
                                        <p>{!! implode('</p><p>', explode("\r\n", $page['header_n4'])) !!}</p>
                                    </div>
                                    <p class="exp-light">{!! implode('</p><p class="exp-light">', explode("\r\n", $page['text_n4'])) !!}</p>
                                </div>
                            </div>
                        </a>
                    </div>
                </div>
                <svg style="width: 55.6%; height: 75.1%" class="line line1">
                    <use xlink:href="#line1"></use>
                </svg>
                <svg style="width: 15.1%; height: 14.9%" class="line line2">
                    <use xlink:href="#line2"></use>
                </svg>
                <svg style="width: 22.6%; height: 39.5%;" class="line line3">
                    <use xlink:href="#line3"></use>
                </svg>
                <svg style="width: 27.5%; height: 14.9%;" class="line line4">
                    <use xlink:href="#line4"></use>
                </svg>
                <svg style="width: 13.7%; height: 26%;" class="line line5">
                    <use xlink:href="#line5"></use>
                </svg>
                <svg style="width: 15.2%; height: 15.2%;" class="line line6">
                    <use xlink:href="#line6"></use>
                </svg>
                <svg style="width: 15.2%; height: 15.2%;" class="line line7">
                    <use xlink:href="#line7"></use>
                </svg>
            </div>
        </div>
        <!--
        <div class="semen semen-pink">
            <svg style="width: 9.81rem; height: 13.5rem" class="svgContainerPink">
                <use xlink:href="#semenSvg-pink"></use>
            </svg>
        </div>
        <div class="semen semen-turquoise">
            <svg style="width: 8.25rem; height: 11.38rem" class="svgContainerPink">
                <use xlink:href="#semenSvg-pink"></use>
            </svg>
        </div>
        -->
    </div>

@endsection