<?php
/**
 * @var $all_clients \Modules\Main\Entities\Client[]
*/
?>
@extends('layouts.main')

@section('page-title',  'Клиенты')
@section('keywords',    '')
@section('description', '')

@section('content')

    <div class="clients page-clients">
        <div class="clients__track">
            <div class="clients__track-stroke">
                <div class="clients__track-caret">
                    @foreach($all_clients as $client)
                    <div class="clients__stroke clients__text">{{ $client->title }}</div>
                    @endforeach
                </div>
            </div>
            <div class="clients__track-fill">
                <div class="clients__track-caret">
                    @foreach($all_clients as $client)
                        <div class="clients__fill clients__text">{{ $client->title }}</div>
                    @endforeach
                </div>
            </div>
        </div>
        <div class="clients__button">
            <div class="clients__button-imgs">
                @php($i=0)
                @foreach($all_clients as $client)
                    <a href="{{ $client->getLink() }}" class="clients__button-imgs-item {{ $i ? '' : 'clients__button-imgs-item--current'}}" style="background-image: url({{ getImagePath($client->image, 312, 317, 'crop') }})"></a>
                    @php($i++)
                @endforeach
            </div>
            <a class="clients__button-text">ПЕРЕЙТИ В КЕЙС</a>
        </div>
    </div>

@endsection