<?php
/**
 * @var $cases \Modules\Main\Entities\CCase[]
*/
?>
@extends('layouts.main')

@section('page-title',  'Кейсы')
@section('keywords',    '')
@section('description', '')

@section('content')

    <div class="page-cases">
<!--         <div class="page-cases__sort">
            <a href="#" class="page-cases__sort-caption">СОРТИРОВАТЬ:</a>
            @foreach($tags as $tag)
            <a href="#" class="page-cases__sort-item">#{{ $tag->title }}</a>
            @endforeach
        </div> -->
        <div class="page-cases__slider">
            @foreach($cases as $case)
            <div class="page-cases__slider-item{{ $case->luminance ? ' imgLight' : '' }}" style="background-image: url({{ getImagePath($case->image, 900, 1200, 'crop') }})" data-link="{{ route('case.show', ['slug' => $case->slug], false) }}">
               <a class="page-cases__read-open" href="{{ route('case.show', ['slug' => $case->slug], false) }}"></a>
                @if($case->video)
                    <a data-fancybox="video" class="page-home__play-buttons-item" href="{{ $case->video }}">
                        <div class="page-home__play-buttons-item-icon"></div>
                    </a>
                @endif
                @if($case->sticker)
                    <img src="/images/general/{{ $case->sticker }}.svg" class="imgMin" alt="">
                @endif
            </div>
            @endforeach
        </div>
        <div class="page-cases__arrows">
            <button class="page-cases__arrows-item page-cases__arrows-item--disabled page-cases__arrows-item--left">
                <svg version="1.1" id="Слой_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 38.4 60.4" style="enable-background:new 0 0 38.4 60.4;" xml:space="preserve" class="page-cases__arrows-svg">
                            <style type="text/css">
                                .cst1 {
                                    clip-path: url(#cSVGID_2_);
                                    fill: #d9ef76;
                                }
                            </style>
                    <g id="group">
                        <path fill="#fff" d="M0.7,0l28.4,30.9L0.7,60.4L0,59.7l27.7-28.9L0,0.7L0.7,0z" class="arrow" />
                        <g>
                            <defs>
                                <path id="cSVGID_1_" class="clip" d="M1.4,0.7h9.4l27.7,30.1L10.7,59.7H1.4l27.7-28.9L1.4,0.7z" style="transform: translateX(-10px);"/>
                            </defs>
                            <clipPath id="cSVGID_2_">
                                <use xlink:href="#cSVGID_1_" />
                            </clipPath>
                            <path class="cst1" d="M1.4,0.7h9.4l27.7,30.1L10.7,59.7H1.4l27.7-28.9L1.4,0.7z" />
                        </g>
                    </g>
                        </svg>

            </button>
            <button class="page-cases__arrows-item page-cases__arrows-item--right">
                <svg version="1.1" id="Слой_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 38.4 60.4" style="enable-background:new 0 0 38.4 60.4;" xml:space="preserve" class="page-cases__arrows-svg">
                            <style type="text/css">
                                .cst2 {
                                    clip-path: url(#cSVGID_4_);
                                    fill: #d9ef76;
                                }
                            </style>
                    <g id="group">
                        <path fill="#fff" d="M0.7,0l28.4,30.9L0.7,60.4L0,59.7l27.7-28.9L0,0.7L0.7,0z" class="arrow" />
                        <g>
                            <defs>
                                <path id="cSVGID_3_" class="clip" d="M1.4,0.7h9.4l27.7,30.1L10.7,59.7H1.4l27.7-28.9L1.4,0.7z" style="transform: translateX(-10px);"/>
                            </defs>
                            <clipPath id="cSVGID_4_">
                                <use xlink:href="#cSVGID_3_" />
                            </clipPath>
                            <path class="cst2" d="M1.4,0.7h9.4l27.7,30.1L10.7,59.7H1.4l27.7-28.9L1.4,0.7z" />
                        </g>
                    </g>
                        </svg>

            </button>
        </div>
        <div class="page-cases__pagination">
            <div class="page-cases__pagination-counter">01</div>
            <div class="page-cases__pagination-indicator">
                <div class="page-cases__pagination-caret"></div>
            </div>
            <div class="page-cases__pagination-number"></div>
        </div>
        <div class="page-cases__read-button" data-text="СМОТРЕТЬ КЕЙС">СМОТРЕТЬ КЕЙС</div>
        <div class="page-cases__descr">

            @php($i=0)
            @foreach($cases as $case)
            <div class="page-cases__descr-item {{ $i ? '' : 'page-cases__descr-item--active' }}">
                <div class="filterTag">
                    @foreach($case->tags as $tag)
                    <span>#{{ $tag->title }}</span>
                    @endforeach
                </div>
                <div class="page-cases__descr-counter">
                    <div class="page-cases__descr-counter-current"></div>
                    <div class="page-cases__descr-counter-all"></div>
                </div>
<div class="page-home__descr-title">
                    <svg class="page-home__descr-title-word1" xmlns="http://www.w3.org/2000/svg">
                        <defs>
                            <clipPath id="clip{{ $i }}">
                                <text class="page-home__descr-title-text " x="-0.5" y="86.5px">{{ $case->splitTitle[0] }}</text>
                                <text class="page-home__descr-title-text " x="0.5" y="86.5px">{{ $case->splitTitle[0] }}</text>
                                <text class="page-home__descr-title-text " x="0.5" y="87.5px">{{ $case->splitTitle[0] }}</text>
                                <text class="page-home__descr-title-text " x="-0.5" y="88px">{{ $case->splitTitle[0] }}</text>
                            </clipPath>
                        </defs>
                        <g>
                            <g clip-path="url(#clip{{ $i }})">
                                <!-- <rect class="page-home__descr-title-rect" x="0" y="0" width="100%" height="100%"></rect> -->
                                <rect class="page-home__descr-title-rect2" x="0" y="0" width="100%" height="100%"></rect>
                            </g>
                            <text class="page-home__descr-title-text" x="0" y="87px">{{ $case->splitTitle[0] }}</text>
                        </g>
                    </svg>
                    <svg class="page-home__descr-title-word2" xmlns="http://www.w3.org/2000/svg">
                        <defs>
                            <clipPath id="clip2{{ $i }}">
                                <text class="page-home__descr-title-text " x="-0.5" y="86.5px">{{ $case->splitTitle[1] }}</text>
                                <text class="page-home__descr-title-text " x="0.5" y="86.5px">{{ $case->splitTitle[1] }}</text>
                                <text class="page-home__descr-title-text " x="0.5" y="87.5px">{{ $case->splitTitle[1] }}</text>
                                <text class="page-home__descr-title-text " x="-0.5" y="88px">{{ $case->splitTitle[1] }}</text>
                            </clipPath>
                        </defs>
                        <g>
                            <g clip-path="url(#clip2{{ $i }})">
                                <rect class="page-home__descr-title-rect" x="0" y="0" width="100%" height="100%"></rect>
                                <rect class="page-home__descr-title-rect2" x="0" y="0" width="100%" height="100%"></rect>
                            </g>
                            <text class="page-home__descr-title-text" x="0" y="87px">{{ $case->splitTitle[1] }}</text>
                        </g>
                    </svg>
                </div>                
                @if($case->brand)
                <div class="page-cases__descr-label">
                    <div class="page-cases__descr-label-caption">КЕЙС:</div>
                    <div class="page-cases__descr-label-text">{{ $case->brand }}</div>
                </div>
                @endif
                @if($case->agency)
                <div class="page-cases__descr-label">
                    <div class="page-cases__descr-label-caption">АГЕНТСТВО:</div>
                    <div class="page-cases__descr-label-text">{{ $case->agency }}</div>
                </div>
                @endif
            </div>
            @php($i++)
            @endforeach
        </div>
    </div>
    <div class="cases"></div>

@endsection