<?php
/**
 * @var $article \Modules\Main\Entities\CCase
*/
?>
@extends('layouts.main')

@section('page-title',  $article->title)
@section('keywords',    '')
@section('description', '')

@section('content')

    <main class="page__main">
        <div class="page__content">
            <div class="page__inner inner">
                <div class="page__back back">
                    <a href="/news/" class="back__link">НАЗАД</a>
                </div>
                <div class="post">
                    <div class="post__img">
                        <img src="{{ getImagePath($article->image, 450, 400, 'crop') }}" alt="">
                        <div class="post__status">
                            @if(!$article->short && $article->sticker)
                                <img src="/images/general/{{ $article->sticker }}.svg" style="max-height: 110px; width: auto" alt="">
                            @endif
                        </div>
                    </div>
                    <div class="typography">
                        <span class="name">
                            {{ date('d.m.Y', strtotime($article->date)) }}
                        </span>
                        <h2>{{ $article->title }}</h2>
                        {!! $article->content ?: $article->anons !!}
                    </div>
                    @if($article->short && $article->link)
                    <div class="post__link">
                        <a href="{{ $article->link }}" rel="nofollow" target="_blank">{{ $article->link }}</a>
                    </div>
                    @endif
                    @if(!$article->short && $article->blocks->isNotEmpty())

                        @if($article->main_image)
                            <div class="post-img">
                                <img src="{{ getImagePath($article->main_image, 450, 200, 'crop') }}" alt="">
                            </div>
                            <br/>
                        @endif

                        @foreach($article->blocks as $block)

                            @switch($block->type)

                                @case(\Modules\Main\Entities\Block::TYPE_SIMPLE_TEXT)

                                <div class="typography">
                                    <h2>{{ $block->title }}</h2>
                                    <p>{!! $block->content1 !!}</p>
                                </div>

                                @break

                                @case(\Modules\Main\Entities\Block::TYPE_TASK_DECISION)
                                <div class="typography">
                                    <span class="name">ЗАДАЧА:</span>
                                    {!! $block->content1 !!}
                                </div>
                                <div class="typography">
                                    <span class="name">РЕШЕНИЕ:</span>
                                    <h2>{{ $block->title }}</h2>
                                    {!! $block->content2 !!}
                                </div>
                                @break

                                @case(\Modules\Main\Entities\Block::TYPE_RESULT)
                                <div class="typography">
                                    <span class="name">РЕЗУЛЬТАТ:</span>
                                    <h2>{{ $block->title }}</h2>
                                    <p>{!! $block->content1 !!}</p>
                                </div>
                                @break

                                @case(\Modules\Main\Entities\Block::TYPE_GALLERY)
                                <div class="post-slider">
                                    <div class="post-slider__container js-slider-easy swiper-container">
                                        <div class="post-slider__wrapper swiper-wrapper">
                                            @foreach($block->images as $image)
                                                <div class="post-slider__box swiper-slide">
                                                    <div class="post-slider__item">
                                                        <img src="{{ getImagePath($image->image, 400, 300, 'crop') }}" alt="">
                                                    </div>
                                                </div>
                                            @endforeach
                                        </div>
                                        <div class="post-slider__arrow">
                                            <button type="button" class="post-slider__arrow-item _prev js-slider-easy-prev"></button>
                                            <button type="button" class="post-slider__arrow-item _next js-slider-easy-next"></button>
                                        </div>
                                    </div>
                                </div>

                                @break

                                @case(\Modules\Main\Entities\Block::TYPE_VIDEO)
                                <div class="post-video">
                                    <a href="{{ $block->video }}" data-fancybox="video" class="post-video__link">
                                        @if($block->image)
                                            <img src="{{ getImagePath($block->image) }}" alt="">
                                        @endif
                                    </a>
                                </div>
                                @break

                            @endswitch

                        @endforeach

                    @endif

                </div>

                <div class="c-nav">
                    <div class="c-nav__inner">
                        <div class="c-nav__wrapper">
                            <div class="c-nav__box">
                                @if($article->previous())
                                    <a href="{{ route('news.show', ['slug' => $article->previous()->slug]) }}" class="c-nav__link _prev">ПРЕДЫДУЩАЯ НОВОСТЬ</a>
                                @endif
                            </div>
                            <div class="c-nav__box">
                                @if($article->next())
                                    <a href="{{ route('news.show', ['slug' => $article->next()->slug]) }}" class="c-nav__link _next">СЛЕДУЮЩАЯ НОВОСТЬ</a>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
                
            </div>
        </div>
    </main>

@endsection