<?php
/**
 * @var $cases \Modules\Main\Entities\CCase[]
*/
?>
@extends('layouts.main')

@section('page-title',  $page['seo_title'])
@section('keywords',    $page['seo_keywords'])
@section('description', $page['seo_description'])

@section('content')


    <main class="page__main _full">
        <div class="slider">
            <div class="slider__container js-home-slider swiper-container">
                <div class="slider__inner swiper-wrapper">
                    @foreach($cases as $case)
                    <div class="slider__slide swiper-slide">
                        <div class="slider__header">
                            <div class="slider__bg" style="background-image: url({{ getImagePath($case->image, 400, 450, 'crop') }})"></div>
                            <div class="slider__info">
                                <div class="slider__inner inner">
                                    <div class="slider-number">
                                        <span class="slider-number__big">#01</span>
                                        <span class="slider-number__min">/{{ $cases->count() < 10 ? '0' : '' }}{{ $cases->count() }}</span>
                                    </div>
                                    <a href="{{ route('case.show', ['slug' => $case->slug], false) }}" class="slider__title">
                                        {{ $case->title }}
                                    </a>
                                    <div class="slider__more-box">
                                        <a href="{{ route('case.show', ['slug' => $case->slug], false) }}" class="slider__more">ПОДРОБНЕЕ</a>
                                    </div>
                                </div>
                                <button type="button" class="slider-arrow__next js-home-slider-next"></button>
                            </div>
                            @if($case->video)
                                <a href="{{ $case->video }}" data-fancybox class="slider__video"></a>
                            @endif
                        </div>
                        <div class="slider__wrap">
                            <div class="slider__content">
                                <div class="slider__inner inner">
                                    <div class="slider-info">
                                        <div class="slider-info__inner">
                                            <div class="slider-info__wrapper">
                                                @if($case->brand)
                                                <div class="slider-info__box">
                                                    <div class="slider-info__name">БРЕНД:</div>
                                                    <div class="slider-info__value">{{ $case->brand }}</div>
                                                </div>
                                                @endif
                                                @if($case->agency)
                                                <div class="slider-info__box">
                                                    <div class="slider-info__name">АГЕНТСТВО:</div>
                                                    <div class="slider-info__value">{{ $case->agency }}</div>
                                                </div>
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                    <div class="slider-tags">
                                        <div class="slider-tags__wrapper">
                                            @foreach($case->tags as $tag)
                                                <a href="#" class="slider-tags__box">#{{ $tag->title }}</a>
                                            @endforeach
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="slider__footer">
                                <div class="slider__inner inner">
                                    <div class="slider-pagination">
                                        <div class="slider-pagination__box">01</div>
                                        <div class="slider-pagination__slider swiper-pagination js-home-slider-pagination"></div>
                                        <div class="slider-pagination__box">{{ $cases->count() < 10 ? '0' : '' }}{{ $cases->count() }}</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endforeach
                </div>
            </div>
        </div>
    </main>

@endsection