<?php
/**
 * @var $page[]
 */
?>
@extends('layouts.main')

@section('page-title',  $page['seo_title'] ? $page['seo_title'] : $page['title'])
@section('keywords',    $page['seo_keywords'])
@section('description', $page['seo_description'])

@section('content')

    <main class="page__main">
        <div class="about">
            <div class="about__img js-animate">
                <img src="{{ getImagePath($page['image'], 600, 700, 'crop') }}" alt="">
                <div class="about__info">
                    <div class="about__inner inner">
                        <div class="about__title">{{ $page['title'] }}</div>
                        <div class="about__desc">
                            {{ $page['sub_title'] }}
                        </div>
                    </div>
                </div>
            </div>
            <div class="about-header js-animate">
                <div class="about-header__inner inner">
                    <div class="about-header__desc">
                        <p>{!! nl2br($page['text']) !!}</p>
                    </div>
                    <div class="about-header__index">
                        <p>{!! nl2br($page['blockquote']) !!}</p>
                    </div>
                </div>
                <canvas id="c-wave" class="about-header__wave"></canvas>
            </div>
            <div class="about-stat">
                <div class="about-stat__inner inner">
                    <div class="about-stat__title">
                        MOVIE В ЦИФРАХ
                    </div>
                    <div class="about-stat__list">
                        <div class="about-stat__box js-animate">
                            <div class="about-stat-item _type-1">
                                <img class="about-stat-item__img" src="/mobile/img/circle-n.svg" alt="">
                                <div class="about-stat-item__wrap">
                                    <div class="about-stat-item__title">
                                        {!! $page['numbers_main'] !!}
                                    </div>
                                    <div class="about-stat-item__desc">
                                        <p>{!! nl2br($page['numbers_main_caption']) !!}</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="about-stat__box js-animate">
                            <div class="about-stat-item _type-2">
                                <img class="about-stat-item__img" src="/mobile/img/about-type-2.svg" alt="">
                                <div class="about-stat-item__wrap">
                                    <div class="about-stat-item__title">
                                        <big>{{ $page['numbers_n1'] }}</big>
                                    </div>
                                    <div class="about-stat-item__desc">
                                        <p>{!! nl2br($page['numbers_n1_caption']) !!}</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="about-stat__box js-animate">
                            <div class="about-stat-item _type-2">
                                <img class="about-stat-item__img" src="/mobile/img/about-type-3.svg" alt="">
                                <div class="about-stat-item__wrap">
                                    <div class="about-stat-item__title">
                                        <big>{{ $page['numbers_n2'] }}</big>
                                    </div>
                                    <div class="about-stat-item__desc">
                                        <p>{!! nl2br($page['numbers_n2_caption']) !!}</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="about-stat__box js-animate">
                            <div class="about-stat-item _type-2">
                                <img class="about-stat-item__img" src="/mobile/img/about-type-4.svg" alt="">
                                <div class="about-stat-item__wrap">
                                    <div class="about-stat-item__title">
                                        <big>{{ $page['numbers_n3'] }}</big>
                                    </div>
                                    <div class="about-stat-item__desc">
                                        <p>{!! nl2br($page['numbers_n3_caption']) !!}</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </main>

@endsection
	
