<?php

namespace App\Providers;

use App\Http\Composers\SettingsComposer;
use Illuminate\Support\Facades\View;
use Illuminate\Support\ServiceProvider;
use Modules\Settings\Entities\Settings;
use Illuminate\Support\Facades\Session;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        $this->app->bind('path.public', function() {
            return base_path('www');
        });
        $this->app->singleton('settings', function($app){
            return $app->make(Settings::class);
        });

        app('router')->bind('locale', function() { return null; });
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        View::composer(['layouts.main','clients'], SettingsComposer::class);
    }
}
