<?php

namespace App\Http\Controllers;

use App\Http\Composers\MainComposer;
use App\Http\Resources\CombinationsResource;
use App\Notifications\MailSubscribe;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;
use Modules\Core\Services\CallbackService;
use Modules\Main\Entities\About;
use Modules\Main\Entities\Article;
use Modules\Main\Entities\Banner;
use Modules\Main\Entities\CCase;
use Modules\Main\Entities\Client;
use Modules\Main\Entities\Contacts;
use Modules\Main\Entities\Expertise;
use Modules\Main\Entities\Main;
use Modules\Notifications\Entities\NotificationType;
use Modules\Pages\Entities\Pages;
use Modules\Settings\Entities\Settings;
use Modules\Main\Entities\Tag;
use Modules\Users\Entities\User;
use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;
use Spatie\Searchable\Search;
use Illuminate\Http\Resources\Json\ResourceCollection;
use Jenssegers\Agent\Agent as Agent;

class IndexController extends Controller
{

    public function index()
    {
        $page       = Main::getAllParams();
        $cases      = CCase::where('act', 1)->where('on_main', 1)->orderBy('pos')->get();

        return view('index', compact('page', 'cases'));
    }

    public function expertise()
    {
        $page       = Expertise::getAllParams();

        return view('expertise', compact('page'));
    }

    public function about()
    {
        $page       = About::getAllParams();

        return view('about', compact('page'));
    }

    public function contacts()
    {
        $page       = Contacts::getAllParams();
        $coordinates =  explode(',', app('settings')->get('coordinates'));

        return view('contacts', compact('page', 'coordinates'));
    }

    public function agencies()
    {
        return view('agencies');
    }

    public function clients(Request $request)
    {
        // mobile detect
        $Agent = new Agent();

        if($Agent->isMobile()){
            return redirect('cases');
        }

        return view('clients');
    }

    public function cases()
    {
        $cases      = CCase::where('act', 1)->orderBy('pos')->get();
        $tags       = Tag::join('case_tag', 'case_tag.tag_id', '=', 'tags.id')
                        ->groupBy(['tags.id', 'tags.title'])
                        ->select(['tags.id', 'tags.title']) //, DB::raw('count(tags.id) as tag_count')])
                        ->orderBy('tags.title', 'asc')->get();
        $icons         = Article::$icons;

        return view('cases', compact('cases', 'tags', 'icons'));
    }

    public function case($slug, Request $request)
    {
        $case = CCase::where('slug', $slug)->with(['blocks','blocks.images'])->first();

        if(!$case || !$case->act) {
            throw new NotFoundHttpException('Page not found');
        }

        $same = CCase::where('act', 1)->where('cases.id', '<>', $case->id)->inRandomOrder()->take(2)->get();
        $ajax = $request->ajax();

        return view('cases_one', compact('case', 'same', 'ajax'));
    }

    public function news()
    {
        $articles      = Article::where('act', 1)->orderBy('pos')->get();
        $icons         = Article::$icons;

        return view('news', compact('articles', 'icons'));
    }

    public function news_one($slug, Request $request)
    {
        $article = Article::where('slug', $slug)->with(['blocks','blocks.images'])->first();

        if(!$article || !$article->act) {
            throw new NotFoundHttpException('Page not found');
        }

        $same = Article::where('act', 1)->where('articles.id', '<>', $article->id)->inRandomOrder()->take(2)->get();
        $ajax = $request->ajax();

        return view('news_one', compact('article', 'same', 'ajax'));
    }

}
