<?php
/**
 * Created by Developer.
 * User: Dmitry S.
 * Date: 25.04.2018
 * Time: 11:11
 */

namespace App\Http\Composers;

use Modules\Main\Entities\Client;
use Modules\Settings\Entities\Settings;
use Illuminate\View\View;

class SettingsComposer
{
    private $settings;
    private $clients;


    public function __construct(Settings $settings)
    {
        $this->settings = $settings;
        $this->clients = Client::where('act', 1)->orderBy('pos')->get();
    }

    public function compose(View $view)
    {
        $view->with('settings', $this->settings);
        $view->with('all_clients', $this->clients);
    }

}