<?php

namespace Modules\Users\Http\Forms;

use Kris\LaravelFormBuilder\Form;
use Modules\Modules\Entities\Modules;
use Modules\Notifications\Entities\NotificationType;
use Modules\Users\Entities\Group;

class UsersForm extends Form
{
    public function buildForm()
    {
        $this
            ->add('name', 'text', [
                'rules' => 'required|min:3',
                'label' => 'Имя'
            ])
            ->add('login', 'text', [
                'rules' => 'required|min:3',
                'label' => 'Логин'
            ])
            ->add('email', 'email', [
                'rules' => 'email',
                'label' => 'E-mail'
            ])
            ->add('avatar', 'image', [
                'label' => 'Аватар',
                'rules' => 'max:2048|mimes:jpg,jpeg,png,gif',
            ])
            ->add('password', 'repeated', [
                'type'           => 'password',
                'value'          => '',
                'first_options'  => [
                    'label' => 'Пароль',
                ],
                'second_options' => [
                    'label' => 'Подтвердите пароль'
                ]
            ])
            ->add('modules', 'entity', [
                'label'    => 'Модули',
                'class'    => Modules::class,
                'property' => 'title',
                'multiple' => true,
                'selected' => function ($data) {
                    return $data ? array_pluck($data, 'id') : [];
                },
                'attr'     => [
                    'class' => 'multi-select'
                ]
            ])
            ->add('groups', 'entity', [
                'label'    => 'Группы',
                'class'    => Group::class,
                'multiple' => true,
                'property' => 'title',
                'selected' => function ($data) {
                    return $data ? array_pluck($data, 'id') : [];
                },
                'attr'     => [
                    'class' => 'multi-select'
                ]
            ]);

        if ($this->getData('is_admin') === true) {
            $this->add('full_access', 'checkbox', [
                'label' => 'Админ'
            ]);

            $this->add('notification_types', 'entity', [
                'label'    => 'Получать уведомления',
                'multiple' => true,
                'attr'     => [
                    'class' => 'multi-select'
                ],
                'class'    => NotificationType::class,
                'selected' => function ($data) {
                    return $data ? array_pluck($data, 'id') : [];
                },
            ]);
        }
    }


}
