<?php

namespace Modules\Users\Http\Forms;

use Kris\LaravelFormBuilder\Form;
use Modules\Modules\Entities\Modules;
use Modules\Users\Entities\User;

class GroupForm extends Form
{
    public function buildForm()
    {
        $this
            ->add('title', 'text', [
                'rules' => 'required|min:3',
                'label' => 'Название'
            ])
            ->add('text', 'textarea', [
                'label' => 'Описание'
            ])

            ->add('users',  'entity', [
                'label' => 'Пользователи',
                'class' => User::class,
                'multiple' => true,
                'selected' => function ($data) {
                    return $data ? array_pluck($data, 'id') : [];
                },
                'attr' => [
                    'class' => 'multi-select'
                ]
            ])

            ->add('modules',  'entity', [
                'label' => 'Модули',
                'class' => Modules::class,
                'property' => 'title',
                'multiple' => true,
                'selected' => function ($data) {
                    return $data ? array_pluck($data, 'id') : [];
                },
                'attr' => [
                    'class' => 'multi-select'
                ]
            ]);

    }


}
