<?php
/**
 * Created by Developer.
 * User: Dmitry S.
 * Date: 30.11.2017
 * Time: 10:58
 */

namespace Modules\Settings\Http\Forms;


use Kris\LaravelFormBuilder\Form;

class SettingContactsForm extends Form
{
    public function buildForm()
    {
        $this
            ->add('contacts', 'editor', [
                'label' => 'Контакты'
            ])
            ;
    }

    private function addTranslatable(string $name, string $type, array $options = []) : Form
    {
        $languages = config('translatable.locales');
        foreach ($languages as $k => $language) {
            $opt = $options;
            if(isset($opt['label'])){
                $opt['label'] .= ' '.$language;
            }

            $this->add($name.'_'.$language, $type, $opt);
        }

        return $this;
    }
}