<?php

namespace Modules\Settings\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Cache;

class Settings extends Model
{

    public $fillable = ['name', 'value'];
    public $timestamps = false;
    private $params = [];
    protected $primaryKey = 'id';

    public function updateParams(array $params)
    {
        foreach ($params as $key=>$value) {
            $item = $this->firstOrCreate(['name'=>$key]);
            $item->value = $value;
            $item->save();
        }
    }

    public function getAllParams()
    {
        if(!$this->params){

            $this->params = $this->allParams();

        }

        return $this->params;
    }

    public function allParams()
    {
        $params = [];
        $list = $this->newQuery()->get(['*'])->toArray();
        foreach ($list as $item) {
            $params[$item['name']] = $item['value'];
        }

        return $params;
    }

    public function get($name)
    {
        $params = $this->getAllParams();

        return isset($params[$name]) ? $params[$name]:'';
    }

    public function getTranslated($name)
    {
        $params = $this->getAllParams();
        $lang = app()->getLocale();

        $l_name = $name.'_'.$lang;

        return isset($params[$l_name]) ? $params[$l_name]:'';
    }

}
