@extends('core::layouts.app')

@section('content')

<form  method="post" enctype="multipart/form-data" class="form-horizontal form-bordered form-label-stripped">
    {{ csrf_field() }}
    <div class="portlet light bordered form-fit">
        <div class="portlet-title">

        </div>
        
        <div class="portlet-body form">
            <div class="form-horizontal form-bordered">
                <div class="form-group {{ $errors->has('title') ? 'has-error':'' }}">
                    <label class="control-label col-md-2">Название *</label>
                    <div class="col-md-9">
                        <input class="form-control" type="text"
                               name="title"
                               style="width:100%;"
                               value="{{ isset($node->title) ? $node->title:'' }}"/>
                        <span class="help-block">{{ $errors->first('title') }}</span>
                    </div>
                </div>
                <div class="form-group {{ $errors->has('path') ? 'has-error':'' }}">
                    <label class="control-label col-md-2">Превдоним</label>
                    <div class="col-md-9">
                        <input class="form-control" type="text"
                               name="path"
                               style="width:100%;"
                               value="{{ isset($node->path) ? $node->path:'' }}"/>
                        <span class="help-block">{{ $errors->first('path') }}</span>
                    </div>
                </div>

                <div class="form-group ">
                    <div class="col-md-12">
                        <textarea name="content" id="content_textarea" class="ckeditor" style="width:100%;" rows="10">{{ isset($node->content) ? $node->content:'' }}</textarea>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    
    <div class="portlet box blue-hoki">
        <div class="portlet-title">
            <div class="caption">
                <i class="fa fa-gift"></i>Дополнительно
            </div>
            <div class="tools">
                <a href="javascript:;" class="expand"></a>
            </div>
        </div>
        <div class="portlet-body form" style="display: none;">
            <div class="form-horizontal form-bordered">

                <div class="form-group">
                    <label class="control-label col-md-2"><?=_('Заголовок')?></label>
                    <div class="col-md-9">
                        <input type="text" name="seo_title" class="form-control" value="<?=isset($node->seo_title) ? trim($node->seo_title):''?>">
                        <input type="checkbox" name="title_parent" id="titleNULL" value="NULL"<?=(isset($node->keywords) && is_null($node->keywords)? ' checked="checked"' : '')?> /><label for="keywordsNULL"><?=_('наследовать от родителя')?></label>
                    </div>
                </div>
                <div class="form-group">
                    <label class="control-label col-md-2"><?=_('Ключевые слова')?></label>
                    <div class="col-md-9">
                        <textarea name="keywords" class="form-control" ><?=isset($node->seo_keywords) ? trim($node->seo_keywords):''?></textarea>
                        <input type="checkbox" name="keywords_parent" id="keywordsNULL" value="NULL"<?=(isset($node->keywords) && is_null($node->keywords)? ' checked="checked"' : '')?> /><label for="keywordsNULL"><?=_('наследовать от родителя')?></label>
                    </div>
                </div>
                <div class="form-group">
                    <label class="control-label col-md-2"><?=_('Описание')?></label>
                    <div class="col-md-9">
                        <textarea name="description" class="form-control" ><?=isset($node->seo_description) ? trim($node->seo_description):''?></textarea>
                        <input type="checkbox" name="description_parent" id="descriptionNULL" value="NULL"<?=(isset($node->description) && is_null($node->description)? ' checked="checked"' : '')?> /><label for="descriptionNULL"><?=_('наследовать от родителя')?></label>
                    </div>
                </div>
                <div class="form-group">
                    <label class="control-label col-md-2"><?=_('Сортировка')?></label>
                    <div class="col-md-9">
                        <input type="number" name="pos" class="form-control" value="<?=isset($node->pos) ? trim($node->pos):''?>">
                    </div>
                </div>

            </div>
        </div>
    </div>
    
    <div class="portlet light bordered form-fit">
        <div class="portlet-body form">
            <div class="form-horizontal form-bordered">
                <div class="form-actions">
                        <div class="row">
                                <div class="col-md-offset-3 col-md-9">
                                        <button type="submit" class="btn purple"><i class="fa fa-check"></i> Сохранить</button>
                                        <button type="reset" class="btn default" onclick="document.location = '{{ route('pages.index') }}'"><?=_('Назад')?></button>
                                </div>
                        </div>
                </div>
            </div>
        </div>
    </div>
    
</form>
@stop