<?php

namespace Modules\Pages\Http\Controllers;

use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Routing\Controller;
use Modules\Pages\Entities\Httree;
use Modules\Core\Services\TranslitServices;

class PagesController extends Controller
{
    use ValidatesRequests;

    protected $tree;

    public function __construct()
    {
        $this->tree = new Httree();
    }

    /**
     * Display a listing of the resource.
     * @return Response
     */
    public function index()
    {
        return view('pages::index');
    }

    public function tree(Request $request)
    {
        if(!$request->isXmlHttpRequest())
        {
            return redirect('pages.index');
        }
        $ret = $this->tree->getTreeItems();

        return \response()->json($ret);
    }

    public function addnode($id)
    {
        $this->addAsset();
        // получаем инфу о родительской ветке
        $parent = $this->tree->getnode($id);
        // если нету такой выдаем ошибку
        if (!$parent) {
            $errors['id'] = true;
        }

        $max_id = \DB::table($this->tree->table)->where('id_parent', $parent->id)->max('id');
        $path = (!$max_id ? '' : ($max_id + 1));

        return view('pages::addnode', compact( 'path', 'parent', 'node', 'action'));
    }

    public function createNode(Request $request, $id)
    {
        $this->validate($request, [
            'title' => 'required',
            //'path' => 'required|regex:~^[a-zA-Z0-9_\-]+$~s',
        ]);

        $parent = $this->tree->getnode($id);

        $isroot = (bool) !$parent;

        $data = [];
        $data['title'] = trim($request->request->get('title'));
        $data['path'] = app()->make(TranslitServices::class)->toUrl($data['title']);
        $data['content'] = trim($request->request->get('content'));
        $data['hidden'] = $request->request->get('hidden', 1);
        // заполняем пропущеные поля
        $seo_title               = $request->request->get('seo_title', null);
        $keywords                = $request->request->get('keywords', null);
        $description             = $request->request->get('description', null);
        $data['seo_title']       = $seo_title ?: $parent->seo_title;
        $data['seo_keywords']    = $keywords ?: $parent->seo_keywords;
        $data['seo_description'] = $description ?: $parent->seo_description;

        if (!$isroot){
            $data['fullpath'] = trim( $parent->fullpath . '/' . $data['path'], '/' );
        }

        if ($id_node = $this->tree->addnode($parent->id, $data))
        {
            return redirect()->route('pages.editnode', $id_node);
        }

        return redirect()->route('pages.index');

    }

    public function editnode($id)
    {

        $node = $this->tree->getnode($id);
        if (!$node)  // not exists
        {
            $errors['id'] = true;
            return redirect('pages.index');
        }

        $this->addAsset();

        $parent = $this->tree->getparent($id);

        $isroot = (bool) !$parent;

        // заполняем пустоту
        $node->hidden = ($node->hidden === NULL ? NULL : $node->hidden);


        return view('pages::editnode', compact( 'isroot', 'parent', 'node', 'action'));
    }

    public function updateNode(Request $request, $id)
    {
        $parent = $this->tree->getparent($id);
        $isroot = (bool)!$parent;

        if ( ! $isroot) {
            $this->validate($request, [
                'title' => 'required',
                'path'  => 'required|regex:~^[a-zA-Z0-9_\-]+$~s|unique:pages,fullpath',
            ]);
        } else {
            $this->validate($request, [
                'title' => 'required',
            ]);
        }

        $data            = [];
        $data['title']   = trim($request->request->get('title'));
        $data['path']   = trim($request->request->get('path'));
        $data['content'] = trim($request->request->get('content'));
        $data['hidden']  = $request->request->get('hidden', 1);
        $data['pos']     = $request->request->get('pos', 1);
        // заполняем пропущеные поля
        $seo_title               = $request->request->get('seo_title', null);
        $keywords                = $request->request->get('keywords', null);
        $description             = $request->request->get('description', null);
        $data['seo_title']       = $seo_title ?: $parent->seo_title;
        $data['seo_keywords']    = $keywords ?: $parent->seo_keywords;
        $data['seo_description'] = $description ?: $parent->seo_description;

        if (!$isroot){
            $data['fullpath'] = trim( $parent->fullpath . '/' . $data['path'], '/' );
        }

        if ($this->tree->update($id, $data)) {
            return redirect()->route('pages.editnode', $id);
        }
        return redirect()->route('pages.index');
    }


    public function delnode(Request $request)
    {
        $id = $request->request->getInt('id');
        $ret['sux'] = 0;
        $ret['msg'] = 'Ошибка при удалении';

        if($id)
        {
            $root = $this->tree->getroot();
            $root = $root[0];
            $node = $this->tree->getnode($id);
            // проверка что не корень, нет потомков и удалили нормально
            if(!empty($node) && ($root->id != $node->id) && !$node->isparent && ($this->tree->del($node->id)))
            {
                $ret['sux'] = 1;
            }
            else
            {
                $ret['msg'] = 'Категория не пустая';
            }
        }
        echo json_encode($ret);
        exit;
    }

    private function addAsset()
    {
        \Assets::addDirJs('/js/constructor/blocks/');
        \Assets::prependJs(['js/constructor/blocks_handler.js', 'js/constructor/helper.js']);
        \Assets::add('css/constructor.css');
    }

}
