<?php

namespace Modules\Pages\Entities;

use Illuminate\Database\Eloquent\Model;

class Pages extends Model
{
    public $table = 'pages';
    protected $fillable = [];

    public function children()
    {
        return $this->hasMany(Pages::class, 'id_parent');
    }

    public function childrenRecursive()
    {
        return $this->children()->with('childrenRecursive');
    }

    public function parent()
    {
        return $this->belongsTo(Pages::class, 'id_parent');
    }
    public function parentRecursive()
    {
        return $this->parent()->with('parentRecursive');
    }

    public function scopeGetBySlug($query, $slug)
    {
        $locale = app()->getLocale() == 'ru' ? '':'/'.app()->getLocale();
        return $query->where('fullpath', $locale.'/'.$slug.'/');
    }

}
