<?php

namespace Modules\Pages\Entities;

class Httree
{
  var $db = NULL;
  var $table = '';
  var $doctable;

  public function __construct($table='pages', $doctable='htdocs')
  {
    $this->table = $table;
    $this->doctable = $doctable;
  }

  // получения инфы ветки по ее пути (может пригодится, щас лишняя см. findnode)
  function getnodebypath($path){
      $q = $this->db->query();
      if(!$q->query("SELECT * FROM {$this->table} WHERE fullpath='{$path}'")) { return false; }
      $ret = $q->get_row();
      return $ret;
  }


    //получение "родителя" узла
    function getparent($id)
    {
        $ret = null;

        $parent = \DB::table($this->table)->where('id', $id)->select('id_parent')->first();

        if ($parent) {
            $ret = \DB::table($this->table)->where('id', $parent->id_parent)->first();
        }

        return $ret;
    }

  //получение массива йд наследников
  function getchild($id,$hidden=0){

      $query = \DB::table($this->table)->where('id_parent', $id)->orderBy('pos');

      if ($hidden){
          $query->where('hidden', 0);
      }

      $ret = $query->get();

      return $ret ? $ret->toArray() : false;
  }
  function getchild2($id,$hidden=0){
      $q = $this->db->query();
      $hid="";
      if ($hidden) $hid=" and hidden=0";
      if(!$q->query("SELECT * FROM htdocs WHERE id_node=$id {$hid} order by pos")) { return false; }
      $ret = $q->get_allrows();
      $q->free_result();
      return $ret;
  }

  //получение списка корня (где уровень равен нулю)
  function getroot($level=0,$hidden=0){

      $query = \DB::table($this->table)->select('*')->where('level', $level)->orderBy('pos');

      if ($hidden){
          $query->where('hidden', 0);
      }

      $ret = $query->get();

      return $ret ?: false;
  }

  //смена родителя
  function setparent($id,$parent){
      //получаем инфу об изменяемом узле
      global $kernel;
      $node=$this->getnode($id);

      $q = $this->db->query();
      //делаем сдвижку позиции всех соседних веток
      if ($node['pos']>0){
        if(!$q->query("UPDATE {$this->table} SET pos=pos-1 WHERE pos>{$node['pos']} and id_parent={$node['id_parent']}")) { return false; }
      }

      //получаем позицию последнего узла у будущего родителя
      if(!$q->query("SELECT max(pos) FROM {$this->table} WHERE id_parent={$parent}")) { return false; }
      $ret=$q->get_row();
      $pos=$ret['pos']+1;

      //изменяем родителя
      if(!$q->query("UPDATE {$this->table} SET pos={$pos}, id_parent='{$parent}' WHERE id = {$id}")) { return false; }

      return 1;

  }


  //повышение положения ветки
  function upnode($id){
      global $kernel;
      $kernel["node"]=$this->getnode($id);
      $q = $this->db->query();
      if ($kernel["node"]["pos"]>0){
        if(!$q->query("SELECT * FROM {$this->table} WHERE id_parent={$kernel["node"]["id_parent"]} and pos={$kernel["node"]["pos"]}-1")) { return false; }
        if ($q->num_rows()>0){
            $ret = $q->get_row();
            $zam_id=$ret["id"];
            if(!$q->query("UPDATE {$this->table} SET pos=pos-1 WHERE id={$kernel["node"]["id"]}")) { return false; }
            if(!$q->query("UPDATE {$this->table} SET pos=pos+1 WHERE id={$zam_id}")) { return false; }
        }
        $q->free_result();
      };
      return 1;
  }

  //полнижение положения ветки
  function downnode($id){
      global $kernel;
      $kernel["node"]=$this->getnode($id);
      $q = $this->db->query();
      if ($kernel["node"]["pos"]>0){
        if(!$q->query("SELECT * FROM {$this->table} WHERE id_parent={$kernel["node"]["id_parent"]} and pos>{$kernel["node"]["pos"]} order by pos asc")) { return false; }
        if ($q->num_rows()>0){
            $ret = $q->get_row();
            $zam_id=$ret["id"];
            if(!$q->query("UPDATE {$this->table} SET pos=pos+1 WHERE id={$kernel["node"]["id"]}")) { return false; }
            if(!$q->query("UPDATE {$this->table} SET pos=pos-1 WHERE id={$zam_id}")) { return false; }
            //echo "UPDATE {$this->table} SET pos=pos+1 WHERE id={$kernel["node"]["id"]}<br>";
            //echo "UPDATE {$this->table} SET pos=pos-1 WHERE id={$zam_id}<br>";
        } else return false;
        $q->free_result();
      };
      return true;
  }

  //изменение положения ветки вверх/вниз

  //получение информации об узле ввиде массива
  function getnode($id, $fields=array())
  {
    $id = intval($id);
    $ret = \DB::table($this->table)->where('id', $id)->first();
    $fields = $this->fields($fields);

    return $ret;
  }
  //получение списка полей как строку с запятыми
  function fields($fields, $prefix='')
  {
    return $prefix. ((is_array($fields) && !empty($fields))? implode(', '.$prefix, $fields) : '*' );
  }

  public function getTreeItems()
  {
      $ret = array();
      $root = $this->getroot();

      foreach ($root as $k=>$el)
      {
          $ret[$k]['text'] = $el->title;
          $ret[$k]['children'] = $this->getTreeItemChildren($el->id);
          $ret[$k]['state'] = array('opened'=>true);
          $ret[$k]['li_attr'] = array(
              'nodeid'=>$el->id,
          );
      }
      
      return $ret;
  }
  
  public function getTreeItemChildren($id)
  {
      $ret = array();
      $childs = $this->getchild($id);
      if (is_array($childs)and(count($childs)>0))
      {
          foreach ($childs as $k=>$el)
          {
            $ret[$k]['text'] = $el->title;
            $ch = $this->getTreeItemChildren($el->id);
            if($ch)
            {
                $ret[$k]['children'] = $ch;
            }
            $ret[$k]['li_attr'] = array(
                'nodeid'=>$el->id,
            );
            
          }
          
      }
      
      return $ret;
  }


 

  //функция возвращает список всех йд веток (для сворачивания/разворачивания всего дерева)
  function listallid(){
       $q = $this->db->query();
       if(!$q->query("SELECT id FROM {$this->table}")) {  return array(); }
       if ($q->num_rows()>0){
            $ret=array();
            $temp1=$q->get_allrows();
            for ($i=0;$i<$q->num_rows();$i++){
                $temp=$temp1[$i];
                $ret[] = $temp['id'];
            }
            return $ret;
       }else{
           return 0;
       }
  }

  //выдает полный список всех
  function returnall($id){
    $q = $this->db->query("SELECT * FROM {$this->table} WHERE NOT(id={$id}) ORDER BY fullpath");
    $ret = $q->get_allrows();
    $q->free_result();
    return $ret;
  }



  //функция выводит подуровни текущей странички
  //в случае если таковых нету выводится текущий уровень
  //учитывается установки параметра hidden
  function printonelevel(){
      global $kernel;
      $level=$kernel["node"]["level"];
      $childs=$this->getchild($kernel['node']['id'],1);
      if (count($childs)>0){
          echo "<ul>";
          while ($el = each($childs)){
              $el=$el[1];
              extract($el,EXTR_PREFIX_ALL,"p");
              echo "<li>$p_id <a href=$p_fullpath>$p_title</a> <a href=?mods=pdocs&act=up&id=$p_id>up</a> <a href=?mods=pdocs&act=down&id=$p_id>down</a></li>";
          }
          echo "</ul>";
      }else{ //eсли не нашли детей печатаем текущий
            $cur = $this->getroot($kernel['node']['level'],1);
            if (count($cur)){
                echo "<ul>";
                while ($el = each($cur)){
                    $el=$el[1];
                    extract($el,EXTR_PREFIX_ALL,"p");
                    echo "<li>$p_id <a href=$p_fullpath>$p_title</a> <a href=?mods=pdocs&act=up&id=$p_id>up</a> <a href=?mods=pdocs&act=down&id=$p_id>down</a></li>";
                }
                echo "</ul>";
            }
      }
  }

  //фунция производит поиск узла по заданому документу
  function findnode($url){
      global $kernel;
      $q = $this->db->query();
      if(!$q->query("SELECT * FROM {$this->table} WHERE fullpath='$url'")) { return false; }
      //echo "SELECT * FROM {$this->table} WHERE fullpath='$url'";
      $ret = $q->get_row();
      if (is_array($ret)){
        return $ret;
      };
      return 0;
  }

  //добавление узла
  function addnode($id, $data)
  {
      //получаем инфу о предке
      $id   = intval($id);
      $node = $this->getnode($id);
      if (empty($node)) {
          return false;
      }

      $pos = \DB::table($this->table)->where('id_parent', $id)->max('pos');

      $data['level']     = $node->level + 1;
      $data['id_parent'] = $node->id;
      $data['fullpath']  = $node->fullpath . $data['path'] . "/";
      $data['pos']       = $pos ? $pos + 1 : 1;

      //задаем что родительская ветка стала "родителем"
      \DB::table($this->table)->where('id', $id)->update(['isparent' => 1]);

      //вставляем данные
      $id = \DB::table($this->table)->insertGetId(
          $data
      );

      return $id;

  }

  //удаление узла
  function del($id){
        //удаляем из таблицы узлов
        $node = $this->getnode($id);
        if(empty($node)) { return false; }

      \DB::transaction(function () use ($id, $node) {
          \DB::table($this->table)->delete($id);

          //меняем позицию оставшихся
          \DB::table($this->table)
             ->where('id_parent', $node->id_parent)
             ->where('pos', '>', $node->pos)
            ->decrement('pos');

          //если больше не осталось детей у предка то снимаем с него статус родителя
          $children = \DB::table($this->table)->where('id_parent', $node->id_parent)->count();

          if ( ! $children) {
              \DB::table($this->table)
                 ->where('id', $node->id_parent)
                 ->update(['isparent'=>0]);
          }
      });


        return true;
  }

  //изменение информации узла (редактирование)
  function update($id,$data){
          \DB::table($this->table)->where('id', $id)->update($data);
          return true;
  }

  //проверка на уникальность пути возвращает кол-во таких путей
  function checkpath($path){
          $q = $this->db->query();
          if(!$q->query("SELECT * FROM {$this->table} WHERE fullpath='{$path}'")){return false;}
          return $q->num_rows();
  }

  //добавление документа
    function insertdoc($id, $data)
    {
        if (empty($data['path'])) {
            return false;
        }
        $node = $this->getnode($id);
        if (empty($node)) {
            return false;
        }

        $data['id_node'] = $node->id;
        $data['pos']     = isset($data['pos']) ? $data['pos'] : 0;

        $id = \DB::table($this->doctable)->insertGetId($data);

        return $id;
    }


  //получение документа
  function getdoc($id, $id_node=0){
      $ret = \DB::table($this->doctable)
                ->where((is_int($id) ? 'id' : 'path'), $id)
                ->where('id_node', $id_node)
                ->first();
//        if(!$q->format("SELECT * FROM {$this->doctable} WHERE (`%s`='%s') AND (id_node='%d' OR '%d'=0) ORDER BY id LIMIT 1", (is_int($id)? 'id' : 'path'), $id, $id_node, $id_node>0)){ return false; }

        return $ret;
  }

  //обновление документа
  function updatedoc($id, $data){
        $q = $this->db->query();
        if((is_array($data) && !empty($data)) || !$data['updated']) {
            $data['updated'] = time();
        }else{
            return false;
        }
        return $q->format("UPDATE {$this->doctable} SET %s WHERE id='%d'", $data, $id);
  }

  //проверка на уникальность имени
  function checkdoc($path,$node,$id=0){
          $q = $this->db->query();
          if(!$q->query("SELECT * FROM {$this->doctable} WHERE path='{$path}' and id_node='{$node}' and NOT(id='{$id}')")){return false;}
          if ($q->num_rows()>0){
              return true;
          }else{
              return false;
          }
  }

  //удаление документа
  function deldoc($id)
  {
    $q = $this->db->query();
    $this->db->transaction();
    if(!$q->format("DELETE FROM {$this->doctable} WHERE id='%d'", $id))
    {
      $this->db->rollback();
      return false;
    }
    $this->db->commit();
    return true;
  }
}

//функция выводит подуровни текущей странички
  //в случае если таковых нету выводится текущий уровень
  //учитывается установки параметра hidden
function printonelevel($chil=true,$template=array()){
    global $kernel;
    $level=$kernel["node"]["level"];
    $tree=$kernel['tree'];
    $childs=$tree->getchild($kernel['node']['id'],1);
    $output='';
    if(!is_array($template) or empty($template)){
        $template = array();
        $template['prefix'] = "<ul class=\'menu\'>\n";
        $template['active'] = "<li class=\'menu-act\'><a href=\".htmlspecialchars(\$fullpath).\" style='broad_link'>\".notags(\$title).\"</a></li>";
        $template['normal'] = "<li class=\'menu-item\'><a href=\".htmlspecialchars(\$fullpath).\".html\".\" style='broad_link'>\".notags(\$title).\"</a></li>";
        $template['suffix'] = "</ul>\n";
    }
    $prefix=$template['prefix'];
    $link=$template['normal'];
    $alink=$template['active'];
    $suffix=$template['suffix'];

    if ((count($childs)>0)&&($chil)){
        eval("\$output=\$output.\"$prefix\";");
        while (list($param,$el) = each($childs)){
            $fullpath=$el['path'];
            $title=$el['title'];
            eval("\$output=\$output.\"$link\";");
       }
        eval("\$output=\$output.\"$suffix\";");
    }else{ //eсли не нашли детей печатаем текущий
        $cur=$tree->getchild($kernel['node']['id_parent'],1);
        if (count($cur)){
            eval("\$output=\$output.\"$prefix\";");
            while (list($param,$el) = each($cur)){
                $fullpath=$el['fullpath'];
                $title=$el['title'];
                $nod=$el['id'];
                $nownod=$kernel['node']['id'];
                if($nod==$nownod){
                    eval("\$output=\$output.\"$alink\";");
                }else{
                    eval("\$output=\$output.\"$link\";");
                }
            }
            eval("\$output=\$output.\"$suffix\";");
        }
    }
    return $output;
}

?>
