<?php
/**
 * Created by Developer.
 * User: Dmitry S.
 * Date: 15.03.2018
 * Time: 16:45
 */

namespace Modules\Notifications\Http\Forms;

use Kris\LaravelFormBuilder\Form;
use Modules\Modules\Entities\Modules;
use Modules\Notifications\Entities\NotificationType;
use Modules\Users\Entities\Group;
use Modules\Users\Entities\User;

class SubscriberForm extends Form
{
    public function buildForm()
    {
        $this
            ->add('name', 'text', [
                'rules' => 'required|min:3',
                'label' => 'Имя'
            ])
            ->add('login', 'text', [
                'rules' => 'required|min:3',
                'label' => 'Логин'
            ])
            ->add('email', 'email', [
                'rules' => 'email',
                'label' => 'E-mail'
            ])
            ->add('notification_types', 'entity', [
                'label'    => 'Виды уведомлений',
                'multiple' => true,
                'attr'     => [
                    'class' => 'multi-select'
                ],
                'class'    => NotificationType::class,
                'selected' => function ($data) {
                    return $data ? array_pluck($data, 'id') : [];
                },
            ])
            ->add('notify', 'checkbox', [
                'value' => 1,
                'label' => 'Подписан на новости',
                'attr' => [
                    'class' => 'make-switch',
                    'data-on-text' => 'Да',
                    'data-off-text' => 'Нет'
                ]
            ]);
    }
}