<?php

namespace Modules\Notifications\Http\Forms;

use Kris\LaravelFormBuilder\Form;
use Modules\Modules\Entities\Modules;
use Modules\Notifications\Entities\NotificationType;
use Modules\Users\Entities\Group;
use Modules\Users\Entities\User;

class CampaignForm extends Form
{
    public function buildForm()
    {
        $this
            ->add('title', 'text', [
                'rules' => 'required|min:3',
                'label' => 'Название'
            ])
            ->add('subject', 'text', [
                'rules' => 'required|min:3',
                'label' => 'Тема письма'
            ])
            ->add('content', 'editor', [
                'label' => 'Содержимое'
            ])
            ->add('act', 'checkbox', [
                'value' => 1,
                'label' => 'Рассылка запущена',
                'attr' => [
                    'class' => 'make-switch',
                    'data-on-text' => 'Да',
                    'data-off-text' => 'Нет'
                ]
            ])
            ->add('subscribers', 'static', [
                'label' => 'Получатели',
                'tag' => 'div',
                'attr' => ['class' => 'form-control-static'],
                'value' => User::where('notify', 1)->count()
            ]);
    }
}