@extends('core::layouts.app')

@section('page-title', $title)

@section('breadcrumb')
    <li>
        <i class="fa fa-circle"></i>
        <a href="{{ route($model_route.'.index') }}">Статьи</a>
    </li>
    <li>
        <i class="fa fa-circle"></i>
        <a href="{{ route($model_route.'.edit') }}">{{ $model->title }}</a>
    </li>
@endsection

@section('content')
    <div class="portlet light ">
        <div class="portlet-title">
            <div class="caption font-red-intense">
                <i class="icon-pin font-red-intense"></i>
                <span class="caption-subject bold uppercase">{{ $title }}</span>
            </div>

            <div class="actions btn-set">
                <a href="{{ route($model_route.'.edit') }}" class="btn btn-default"> К статье</a>
            </div>
        </div>

        <div class="portlet-body form">

            <div class="tabbable-line">
                <ul class="nav nav-tabs ">
                    <li class="active">
                        <a href="#tab_1" data-toggle="tab">Общее</a>
                    </li>
                    @if($item->type == \Modules\Main\Entities\Block::TYPE_GALLERY)
                    <li>
                        <a href="#tab_images" data-toggle="tab">Галерея</a>
                    </li>
                    @endif
                </ul>

                <div class="tab-content">
                    <div class="tab-pane active" id="tab_1">

                        {!! form_start($form, ['class'=>'form-horizontal form-bordered form-label-stripped']) !!}
                        {!! form_rest($form) !!}
                        <div class="form-actions">
                            <div class="row">
                                <div class="col-md-offset-3 col-md-9">
                                    <button type="submit" class="btn purple"><i class="fa fa-check"></i> Сохранить </button>
                                    <button type="button" class="btn default" onclick="document.location = '{{ route($model_route.'.edit') }}'">Отмена</button>
                                </div>
                            </div>
                        </div>

                        {!! form_end($form) !!}
                    </div>

                    @if($item->type == \Modules\Main\Entities\Block::TYPE_GALLERY)
                        <div class="tab-pane " id="tab_images">
                            @include('core::partials.upload_images', [
                                'images_table' => 'block_images',
                                'table_link' => 'block_id',
                                'item_id' => $item->id
                            ])
                        </div>
                    @endif

                </div>
            </div>

        </div>
    </div>
@endsection