@extends('core::layouts.app')

@section('page-title', 'О компании')

@section('content')
    <div class="portlet light ">
        <div class="portlet-title">
            <div class="caption font-red-intense">
                <i class="icon-pin font-red-intense"></i>
                <span class="caption-subject bold uppercase">@yield('page-title')</span>
            </div>

        </div>

        <div class="portlet-body form">

            {!! form_start($form, ['class'=>'form-horizontal form-bordered form-label-stripped']) !!}

            <div class="tabbable-line">
                <ul class="nav nav-tabs ">
                    <li class="active">
                        <a href="#tab_1" data-toggle="tab">Общее</a>
                    </li>
                    @foreach($form->getFields() as $name=>$value)
                        @if( $value instanceof \Kris\LaravelFormBuilder\Fields\ChildFormType
                            && $value->getOption('tab')
                        )
                            <li>
                                <a href="#tab_{{ $name }}" data-toggle="tab">{{ $value->getOption('label') }}</a>
                            </li>
                        @endif
                    @endforeach

                </ul>

                <div class="tab-content">
                    <div class="tab-pane active" id="tab_1">
                        @foreach($form->getFields() as $name=>$value)
                            @if(!$value instanceof \Kris\LaravelFormBuilder\Fields\ChildFormType
                                || !$value->getOption('tab')
                            )
                                {!! form_row($value) !!}
                            @endif
                        @endforeach
                    </div>

                    @foreach($form->getFields() as $name=>$value)
                        @if( $value instanceof \Kris\LaravelFormBuilder\Fields\ChildFormType
                            && $value->getOption('tab')
                        )
                            <div class="tab-pane" id="tab_{{ $name }}">
                                {!! form_row($value) !!}
                            </div>
                        @endif
                    @endforeach

                </div>
            </div>

            <div class="form-actions">
                <div class="row">
                    <div class="col-md-offset-3 col-md-9">
                        <button type="submit" class="btn purple"><i class="fa fa-check"></i> Сохранить </button>
                        <button type="button" class="btn default" onclick="document.location = '{{ route('main.index') }}'">Отмена</button>
                    </div>
                </div>
            </div>

            {!! form_end($form) !!}


        </div>
    </div>
@endsection