<?php
/**
 * Created by Developer.
 * User: Dmitry S.
 * Date: 23.04.2018
 * Time: 12:34
 */

namespace Modules\Main\Http\Forms;


use Kris\LaravelFormBuilder\Form;
use Modules\Main\Entities\Article;
use Modules\Main\Entities\Tag;

class CCaseForm extends Form
{
    public function buildForm()
    {
        $stickers = Article::$icons;

        $this
            ->add('title', 'text', [
                'label' => 'Название',
                'rules' => 'required'
            ])
            ->add('slug', 'slug', [
                'label' => 'Псевдоним',
                'table' => 'cases'
            ])
            ->add('brand', 'text', [
                'label' => 'Бренд'
            ])
            ->add('agency', 'text', [
                'label' => 'Агентство'
            ])
            ->add('video', 'text', [
                'label' => 'Видео'
            ])
            ->add('image', 'image', [
                'label' => 'Изображение',
                'help_block' => [
                    'text' => 'Размер изображения на сайте: 900x1200',
                ]
            ])
            ->add('sticker', 'choice', [
                'label' => 'Стикер',
                'choices' => ['' => 'Без стикера']+$stickers,
                'choice_options' => [
                    'wrapper' => ['class' => 'choice-wrapper'],
                    'label_attr' => ['class' => 'label-class'],
                ]
            ])
            ->add('tags',  'entity', [
                'label' => 'Теги',
                'class' => Tag::class,
                'property' => 'title',
                'multiple' => true,
                'selected' => function ($data) {
                    return $data ? \Arr::pluck($data, 'id') : [];
                },
                'attr' => [
                    'class' => 'multi-select'
                ]
            ])
            ->add('anons', 'editor', [
                'label' => 'Инфо'
            ])
            ->add('on_main', 'checkbox', [
                'label' => 'На главной'
            ])
            ->add('act', 'checkbox', [
                'label' => 'Показывать'
            ])
        ;
    }
}