<?php

namespace Modules\Main\Http\Forms;

use Kris\LaravelFormBuilder\Form;
use Modules\Core\Forms\SeoMetaForm;
use Modules\Main\Entities\Block;

class BlockForm extends Form
{
    public function buildForm()
    {

        $this
            ->add('type', 'choice', [
                'label' => 'Тип блока',
                'choices' => $this->model ? [ $this->model['type'] => Block::$types[$this->model['type']] ] : Block::$types,
                'choice_options' => [
                    'wrapper' => ['class' => 'choice-wrapper'],
                    'label_attr' => ['class' => 'label-class'],
                ],
                'attr' => [
                    'readonly' => $this->model ? true : false
                ]
            ])
            ->add('title', 'text', [
                'label' => 'Название'
            ])
        ;

        if(!$this->model) {

            $this
                ->add('content1', 'hidden')
                ->add('content2', 'hidden')
                ->add('image', 'image')
                ->add('video', 'hidden')
            ;


        } else {

            switch ($this->model['type']) {

                case Block::TYPE_SIMPLE_TEXT:

                    $this
                        ->add('content1', 'editor', [
                            'label' => 'Содержимое'
                        ]);

                    break;

                case Block::TYPE_TASK_DECISION:

                    $this
                        ->add('content1', 'editor', [
                            'label' => 'Задача'
                        ])
                        ->add('content2', 'editor', [
                            'label' => 'Решение'
                        ])
                    ;

                    break;

                case Block::TYPE_RESULT:

                    $this
                        ->add('content1', 'editor', [
                            'label' => 'Результат'
                        ])
                    ;

                    break;

                case Block::TYPE_GALLERY:

                    break;

                case Block::TYPE_VIDEO:

                    $this
                        ->add('image', 'image', [
                            'label' => 'Обложка видео'
                        ])
                        ->add('video', 'text', [
                            'label' => 'Видео',
                            'help_block' => [
                                'text' => 'Пример ссылки с необходимыми параметрами: https://www.youtube.com/embed/AulpWTIdrgk?wmode=opaque&amp;autohide=1&amp;autoplay=1&amp;enablejsapi=1',
                            ]
                        ])
                    ;

                    break;

            }
        }

    }

}
