<?php
/**
 * Created by Developer.
 * User: Dmitry S.
 * Date: 23.04.2018
 * Time: 12:34
 */

namespace Modules\Main\Http\Forms;


use Kris\LaravelFormBuilder\Form;
use Modules\Main\Entities\Article;
use Modules\Main\Entities\Tag;

class ArticleForm extends Form
{
    public function buildForm()
    {

        $stickers = Article::$icons;

        $this
            ->add('title', 'text', [
                'label' => 'Название',
                'rules' => 'required'
            ])
            ->add('slug', 'slug', [
                'label' => 'Псевдоним',
                'table' => 'cases'
            ])
            ->add('date', 'date', [
                'label' => 'Дата'
            ])
            ->add('image', 'image', [
                'label' => 'Изображение превью',
                'help_block' => [
                    'text' => 'Размер изображения на сайте: 900x1200',
                ]
            ])
            ->add('anons', 'editor', [
                'label' => 'Анонс'
            ])
            ->add('content', 'editor', [
                'label' => 'Полный текст'
            ]);


        if ($this->model) {

            if($this->model['short']) {
                $this
                    ->add('link', 'text', [
                        'label' => 'Ссылка на источник'
                    ])
                ;
            } else {
                $this
                    ->add('sticker', 'choice', [
                        'label' => 'Стикер',
                        'choices' => ['' => 'Без стикера']+$stickers,
                        'choice_options' => [
                            'wrapper' => ['class' => 'choice-wrapper'],
                            'label_attr' => ['class' => 'label-class'],
                        ]
                    ])
                    ->add('main_image', 'image', [
                        'label' => 'Изображение растяжка',
                        'help_block' => [
                            'text' => 'Размер изображения на сайте: 1600x650',
                        ]
                    ])
                ;
            }

        } else {
            $this
                ->add('link', 'hidden')
                ->add('sticker', 'hidden')
                ->add('main_image', 'hidden')
            ;
        }

        $this
            ->add('short', 'checkbox', [
                'label' => 'Короткая новость'
            ])
            ->add('act', 'checkbox', [
                'label' => 'Показывать'
            ])
        ;

    }
}