<?php

namespace Modules\Main\Http\Forms;

use Kris\LaravelFormBuilder\Form;
use Modules\Core\Forms\SeoMetaForm;

class AboutForm extends Form
{
    public function buildForm()
    {

        $this
            ->add('seo', 'tabform', [
                'label' => 'SEO',
                'class' => SeoMetaForm::class
            ])
            ->add('numbers', 'tabform', [
                'label' => 'Цифры',
                'class' => AboutNumbersForm::class
            ])
        ;

        $this
            ->add('title', 'text', [
                'label' => 'Название страницы'
            ])
            ->add('sub_title', 'text', [
                'label' => 'Подзаголовок'
            ])
            ->add('text', 'textarea', [
                'label' => 'Краткий текст'
            ])
            ->add('blockquote', 'textarea', [
                'label' => 'Цитата'
            ])
            ->add('image', 'image', [
                'label' => 'Изображение',
                'help_block' => [
                    'text' => 'Размер изображения на сайте: 900x1200',
                ],
                'rules' => 'max:2048|mimes:jpg,jpeg,png,gif',
            ])
        ;

    }

    private function addTranslatable(string $name, string $type, array $options = []) : Form
    {
        $languages = config('translatable.locales');
        foreach ($languages as $k => $language) {
            $opt = $options;
            if(count($languages)>1 && isset($opt['label'])){
                $opt['label'] .= ' '.$language;
            }

            $this->add($name.'_'.$language, $type, $opt);
        }

        return $this;
    }

}
