<?php

namespace Modules\Main\Http\Controllers;

use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Routing\Controller;
use Kris\LaravelFormBuilder\FormBuilderTrait;
use Kris\LaravelFormBuilder\FormBuilder;
use Modules\Main\Entities\Expertise;
use Modules\Main\Http\Forms\ExpertiseForm;

class ExpertiseController extends Controller
{
    use ValidatesRequests;
    use FormBuilderTrait;

    protected $tabs = ['seo','numbers'];

    public function index(Expertise $expertise, FormBuilder $form_builder)
    {

        $values = $expertise->allParams();

        foreach($this->tabs as $tab) {
            $values[$tab] = array();
            foreach($values as $i=>$value) {
                if(strpos($i, $tab.'_') === 0) {
                    $values[$tab][$i] = $value;
                }
            }
        }

        $form = $form_builder->create(ExpertiseForm::class,[
            'method' => 'POST',
            'url' => route('expertise.store'),
            'model' => $values
        ]);

        return view('main::expertise', compact('form'));
    }

    public function store(Expertise $expertise)
    {

        $form = $this->form(ExpertiseForm::class);

        // It will automatically use current request, get the rules, and do the validation
        if (!$form->isValid()) {
            return redirect()->back()->withErrors($form->getErrors())->withInput();
        }

        $form->redirectIfNotValid();

        $values = $form->getFieldValues();

        foreach($this->tabs as $tab) {
            if(isset($values[$tab])) {
                $values += $values[$tab];
                unset($values[$tab]);
            }
        }

        $expertise->updateParams($values);

        return redirect()->route('expertise.index');
    }
}


