<?php

namespace Modules\Main\Http\Controllers;

use Caffeinated\Flash\Facades\Flash;
use Illuminate\Http\Request;
use Modules\Core\Http\Controllers\CrudController;
use Modules\Core\Http\Controllers\ServiceController;

class CCasesController extends CrudController
{
    public $titles = ['Кейсы', 'кейса'];
    protected $templateEdit = 'main::cases.edit';
    protected $isSortable = true;
    protected $luminance = true;
    protected $relations = ['tags'];

    protected function listFields()
    {
        return [
            'title' => [
                'title' => 'Название',
                'link' =>''
            ],
            'brand' => [
                'title' => 'Бренд',
                'link' =>''
            ],
            'agency' => [
                'title' => 'Агентство',
                'link' =>''
            ],
            'on_main' => [
                'title' => 'На главной',
                'link' => '',
                'values' => [0=>'Нет',1=>'Да']
            ],
            'act' => [
                'title' => 'Активно',
                'link' => '',
                'values' => [0=>'Нет',1=>'Да']
            ]
        ];
    }
}
