<?php

namespace Modules\Main\Http\Controllers;

use Caffeinated\Flash\Facades\Flash;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\URL;
use Illuminate\View\View;
use Kris\LaravelFormBuilder\FormBuilder;
use Modules\Core\Http\Controllers\Controller;
use Modules\Main\Entities\CCase;
use Modules\Main\Entities\Block;
use Modules\Main\Entities\Article;
use Modules\Main\Http\Forms\BlockForm;

class BlocksController extends Controller
{
    public $model;
    public $model_route;
    private $builder;

    public function __construct(FormBuilder $builder)
    {
        $this->builder = $builder;
    }

    public function create()
    {
        $form = $this->builder->create($this->getForm(), [
            'method' => 'POST',
            'url'    => route($this->model_route.'.blocks.store'),
        ]);

        return view('main::blocks.create', [
            'form'         => $form,
            'title'        => 'Создание нового блока содержимого',
        ]);
    }

    public function store(Request $request)
    {
        $values = $this->getFormValues();

        $values['entity_class'] = get_class($this->model);

        $item = $this->model->blocks()->create($values);

        return redirect(route($this->model_route.'.edit'));
    }

    public function edit(Block $block)
    {
        $form = $this->builder->create($this->getForm(), [
            'method' => 'PATCH',
            'url'    => route($this->model_route.'.blocks.update', $block->id),
            'model'  => $block->toArray(),
        ]);

        return view('main::blocks.edit', [
            'form'         => $form,
            'item'         => $block,
            'title'        => 'Редактирование блока',
        ]);
    }

    public function update(Block $block)
    {
        $values = $this->getFormValues();
        $block->update($values);

        Flash::success('Запись обновлена');

        return redirect(route($this->model_route.'.edit'));
    }

    public function destroy(Block $block)
    {
        $block->delete();

        Flash::success('Запись удалена.');

        return redirect(route($this->model_route.'.edit'));
    }

    private function getForm()
    {
        return BlockForm::class;
    }

    private function getFormValues()
    {
        $form = $this->builder->create($this->getForm());
        $form->redirectIfNotValid();
        return $form->getFieldValues();
    }

    public function callAction($method, $parameters)
    {
        if(isset($parameters['ccase'])) {
            $model_key = 'ccase';
            $model_class = CCase::class;
        } else
        if(isset($parameters['article'])) {
            $model_key = 'article';
            $model_class = Article::class;
        } else {
            return false;
        }

        $this->model_route = $model_key.'s';

        $model_id = $parameters[$model_key];
        $this->model = $model_class::findOrFail($model_id);

        unset($parameters[$model_key]);

        URL::defaults([$model_key => $this->model->id]);
        view()->composer(['main::blocks.*'], function(View $view) {
            $view->with('model', $this->model);
            $view->with('model_route', $this->model_route);
        });

        return parent::callAction($method, $parameters);
    }


}
