<?php

namespace Modules\Main\Entities;

use Illuminate\Database\Eloquent\Model;

class Client extends Model
{
    protected $guarded = [];
    public $timestamps = false;

    public function case()
    {
        return $this->belongsTo(CCase::class, 'case_id');
    }

    public function getTitleAttribute()
    {
        return mb_strtoupper($this->attributes['title'], 'UTF-8');
    }

    public function getLink()
    {
        if($this->link) {
            return $this->link;
        } else
        if($this->case) {
            return '/cases/' . $this->case->slug;
        }

        return '#';
    }

}
