<?php

namespace Modules\Main\Entities;

use App\Filters\Filterable;
use App\Filters\QueryFilters;
use Illuminate\Database\Eloquent\Model;

class Article extends Model
{
    // TODO: replace trait
    use Filterable;

    protected $guarded = [];
    public static $icons = [
        'women'     => 'Women',
        'cup'       => 'Cup',
        'grib'      => 'Mushroom',
        'cat'       => 'Flying cat',
        'heart'     => 'Pixel heart',
    ];

    public function getRouteKeyName()
    {
        return 'slug';
    }

    public function blocks()
    {
        return $this->hasMany(Block::class, 'entity_id')
            ->where('entity_class', Article::class)->orderBy('pos');
    }

    public function next(){
        return Article::where('act', 1)->where('pos', '>', $this->pos)->orderBy('pos','asc')->first();

    }
    public function previous(){
        return Article::where('act', 1)->where('pos', '<', $this->pos)->orderBy('pos','desc')->first();
    }

}
