<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCaseTagTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('case_tag', function (Blueprint $table) {
            $table->unsignedInteger('case_id');
            $table->unsignedInteger('tag_id');

            $table->foreign('case_id')->on('cases')->references('id')->onDelete('cascade');
            $table->foreign('tag_id')->on('tags')->references('id')->onDelete('cascade');

            $table->unique(['case_id', 'tag_id']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('case_tag');
    }
}
