<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateExpertiseTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('expertise', function (Blueprint $table) {
            $table->increments('id');
            $table->string('name', 191)->unique();
            $table->text('value')->nullable();
        });

        DB::table('expertise')->insert([
            ['name'  =>  'seo_title'],
            ['name'  =>  'seo_description'],
            ['name'  =>  'seo_keywords'],
        ]);

        $item = DB::table('modules')->where('name', 'expertise')->first();

        if(!$item){
            DB::table('modules')->insert( [
                'name' => 'expertise',
                'section' => 'modules',
                'title' => 'Экспертизы',
            ]);
        }

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('expertise');
    }
}
