<?php

namespace Modules\Core\Http\Controllers;


use Illuminate\Http\Request;
use Illuminate\Http\UploadedFile;

class ImagesController extends Controller
{
    public function uploadOne(Request $request)
    {
        $this->validate($request, [
            'image' => 'image'
        ]);

        $file = $request->file('image');

        if($file instanceof UploadedFile) {
            try{
                $image = $file->store('/images/page');
                $response['uploadName'] = '/uploads/'.$image;
                $response['success'] = true;
            }catch (\Exception $e){
                $response['error'] = $e->getMessage();
            }

        }else{
            $response['error'] = "Ошибка при загрузке файла";
        }

        return response()->json($response);
    }

    public function upload(Request $request)
    {
        $this->validate($request, [
            'qqfile' => 'image'
        ]);

        $data = [];
        $id = $request->request->get('id');
        $table = $request->request->get('table');
        $link = $request->request->get('link', false);
        $file = $request->file('qqfile');


        if($file instanceof UploadedFile) {
            try{
                $image = $file->store('/images');
                $data['image'] = $image;
                if($link){
                    $data[$link] = $id;
                }
                $data['pos']  = \DB::table($table)->max('pos') + 1;

                $uuid = \DB::table($table)->insertGetId($data);

                $response['uploadName'] = getImagePath($image, 120, 100);
                $response['image'] = \Storage::url($image);
                $response['success'] = true;
                $response['uuid'] = $uuid;
                $response['newUuid'] = $uuid;
                $response['file-id'] = $uuid;
                $response['file_id'] = $uuid;
            }catch (\Exception $e){
                $response['error'] = $e->getMessage();
            }

        }else{
            $response['error'] = "Ошибка при загрузке файла";
        }

        return response()->json($response);
    }

    public function files_list(Request $request)
    {
        $id = $request->request->get('id');
        $table = $request->request->get('table');
        $link = $request->request->get('link', false);

        if($link){
            $items = \DB::table($table)->select(\DB::raw('*, id as uuid, image as name'))->where($link, $id)
                ->orderBy('pos')->get();
        }else{
            $items = \DB::table($table)->select(\DB::raw('*, id as uuid, image as name'))->get();
        }

        foreach ($items as $item) {
            $item->thumbnailUrl = getImagePath($item->name, 120, 100);
        }

        return response()->json($items);
    }

    public function destroy(Request $request, $id)
    {
        $table = $request->get('table');
        $response = ['result' => false];

        if($id){
            $item = \DB::table($table)->find($id);
            \Storage::delete($item->image);
            \DB::table($table)->delete($id);
            $response['result'] = true;
        }

        return response()->json($response);
    }

    public function sortImages(Request $request)
    {
        $ids = $request->get('ids', []);
        $table = preg_replace('/[^A-z0-9-_]/', '', $request->get('tbl', ''));

        $pos = 0;

        foreach ($ids as $id) {
            if ($id == '') continue;
            \DB::table($table)->where('id', $id)->update(['pos' => $pos]);
            $pos++;
        }

        return response()->json(['success' => true]);
    }
}
