<?php
namespace Modules\Core\Forms\Fields;

use Illuminate\Support\Facades\DB;
use Kris\LaravelFormBuilder\Fields\FormField;
use Modules\Core\Services\TranslitServices;

class SlugType extends FormField
{

    /**
     * Get the template, can be config variable or view path.
     *
     * @return string
     */
    protected function getTemplate()
    {
        return 'text';
    }

    public function getType()
    {
        return 'text';
    }

    public function getDefaults()
    {
        return [
            'source' => 'title',
            'table' => '',
            'help_block' => [
                'text' => 'Не обязательно для заполнения',
                'tag' => 'p',
                'attr' => ['class' => 'help-block']
            ],
        ];
    }

    public function alterFieldValues(&$value)
    {
        $request = $this->parent->getRequest()->all();
        $source = $this->getOption('source');
        $table = $this->getOption('table');
        $string = $value;

        if(!$string){
            $string = $this->stringToSlug(array_get($request, $source));
        }

        $value = $this->makeSlug($string, $table, $this->parent->getModel());

    }

    protected function makeSlug($string, $table, $model = null, $iteration = 0)
    {
        $value = $this->stringToSlug($string.($iteration?:''));

        if($string == $value){
            return $value;
        }

        if($table){
            $item = DB::table($table)->where('slug', $value)->first();
            if($item){
                $iteration++;
                return $this->makeSlug($string, $table, $model, $iteration);
            }
        }

        return $value;
    }

    protected function searchArray( array $array, $search )
    {
        while( $array ) {
            if( isset( $array[ $search ] ) ) return $array[ $search ];
            $segment = array_shift( $array );
            if( is_array( $segment ) ) {
                if( $return = $this->searchArray( $segment, $search ) ) return $return;
            }
        }
        return false;
    }


    protected function stringToSlug($value)
    {
        return \Str::slug($value);
    }

}