<?php

namespace Modules\Core\Contracts;

use Spatie\Searchable\Searchable;
use Spatie\Searchable\SearchResult;

class SearchDetailedResults extends SearchResult
{
    /** @var null|string */
    public $image;

    /** @var string */
    public $type;

    /** @var string */
    public $path_title;

    /** @var string */
    public $path_url;

    /** @var string */
    public $description;

    /** @var string */
    public $comingSoon;


    public function __construct(
        Searchable $searchable, string $title,
        ?string $url = null, ?string $image = null,
        ?string $path_title = null, ?string $path_url = null,
        ?string $description = null,
        bool $comingSoon = false
    )
    {
        $this->searchable = $searchable;
        $this->title    = $title;
        $this->url      = $url;
        $this->image    = $image;
        $this->path_title   = $path_title;
        $this->path_url     = $path_url;
        $this->description  = $description;
        $this->comingSoon   = $comingSoon;
    }
}