<?php

namespace Modules\Callback\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Routing\Controller;
use Modules\Core\Http\Controllers\CrudController;
use Modules\Callback\Entities\Callback;

class CallbackController extends CrudController
{
    protected $titles = ['Обратные звонки', 'звонка'];
    protected $templateEdit = 'callback::edit';

    protected function listFields()
    {
        return [
            'topic' => [
                'Раздел' => 'Тема',
            ],
            'fio' => [
                'title' => 'Фио',
            ],
            'phone' => [
                'title' => 'Телефон',
            ],
            'created_at' => [
                'title' => 'Дата',
            ],
        ];
    }


    /**
     * Display a listing of the resource.
     * @return Response
     */
    public function index()
    {
        $callbacks = Callback::orderBy('created_at', 'desc')->paginate(25);

        return view('callback::index', compact('callbacks'));
    }

    public function store(Request $request)
    {
        $item = $this->crudService->store();

        return $this->redirectToAction('index');
    }

    public function edit($id)
    {
        $item = $this->crudService->getItemById($id);
        $route = action($this->getActionRoute('update'), ['id' => $id]);
        $form = $this->crudService->getEditForm($item, $route);

        return view($this->templateEdit, [
            'form' => $form,
            'title' => $this->getTitle('edit'),
            'module_title' => $this->getTitle('index'),
            'controller' => $this->getController(),
            'item' => $item,
        ]);
    }

    public function update($id, Request $request)
    {
        $offer = $this->crudService->update($id);

        return $this->redirectToAction('index');
    }
}
