$(function(){
    var wave = $('#c-wave');
    if (!wave.length) return
    var c = document.getElementById('c-wave'),
        ctx = c.getContext('2d'),
        cw = c.width = window.innerWidth,
        ch = c.height = window.innerWidth/2,
        points = [],
        tick = 0,
        opt = {
            count: 5,
            range: {
                x: 20,
                y: 40
            },
            duration: {
                min: 60,
                max: 70
            },
            thickness: 0,
            strokeColor: '#3D2683',
            level: .35,
            curved: true
        },
        rand = function(min, max){
            return Math.floor( (Math.random() * (max - min + 1) ) + min);
        },
        ease = function (t, b, c, d) {
            if ((t/=d/2) < 1) return c/2*t*t + b;
            return -c/2 * ((--t)*(t-2) - 1) + b;
        };

    ctx.lineJoin = 'round';
    ctx.lineWidth = opt.thickness;
    ctx.strokeStyle = opt.strokeColor;

    var Point = function(config){
        this.anchorX = config.x;
        this.anchorY = config.y;
        this.x = config.x;
        this.y = config.y;
        this.setTarget();
    };

    Point.prototype.setTarget = function(){
        this.initialX = this.x;
        this.initialY = this.y;
        this.targetX = this.anchorX + rand(0, opt.range.x * 2) - opt.range.x;
        this.targetY = this.anchorY + rand(0, opt.range.y * 2) - opt.range.y;
        this.tick = 0;
        this.duration = rand(opt.duration.min, opt.duration.max);
    }

    Point.prototype.update = function(){
        var dx = this.targetX - this.x;
        var dy = this.targetY - this.y;
        var dist = Math.sqrt(dx * dx + dy * dy);

        if(Math.abs(dist) <= 0){
            this.setTarget();
        } else {
            var t = this.tick;
            var b = this.initialY;
            var c = this.targetY - this.initialY;
            var d = this.duration;
            this.y = ease(t, b, c, d);

            b = this.initialX;
            c = this.targetX - this.initialX;
            d = this.duration;
            this.x = ease(t, b, c, d);

            this.tick++;
        }
    };

    Point.prototype.render = function(){
        ctx.beginPath();
        ctx.arc(this.x, this.y, 3, 0, Math.PI * 2, false);
        ctx.fillStyle = '#3D2683';
        ctx.fill();
    };

    var updatePoints = function(){
        var i = points.length;
        while(i--){
            points[i].update();
        }
    };

    var renderPoints = function(){
        var i = points.length;
        while(i--){
            points[i].render();
        }
    };

    var renderShape = function(){
        ctx.beginPath();
        var pointCount = points.length;
        ctx.moveTo(points[0].x, points[0].y);
        var i;
        for (i = 0; i < pointCount - 1; i++) {
            var c = (points[i].x + points[i + 1].x) / 2;
            var d = (points[i].y + points[i + 1].y) / 2;
            ctx.quadraticCurveTo(points[i].x, points[i].y, c, d);
        }
        ctx.lineTo(-opt.range.x - opt.thickness, ch + opt.thickness);
        ctx.lineTo(cw + opt.range.x + opt.thickness, ch + opt.thickness);
        ctx.closePath();
        ctx.fillStyle = '#3D2683';
        ctx.fill();
        ctx.stroke();
    };

    var clear = function(){
        ctx.clearRect(0, 0, cw, ch);
    };

    var loop = function(){
        window.requestAnimFrame(loop, c);
        tick++;
        clear();
        updatePoints();
        renderShape();
        //renderPoints();
    };

    var i = opt.count + 2;
    var spacing = (cw + (opt.range.x * 2)) / (opt.count-1);
    while(i--){
        points.push(new Point({
            x: (spacing * (i - 1)) - opt.range.x,
            y: ch - (ch * opt.level)
        }));
    }

    window.requestAnimFrame=function(){return window.requestAnimationFrame||window.webkitRequestAnimationFrame||window.mozRequestAnimationFrame||window.oRequestAnimationFrame||window.msRequestAnimationFrame||function(a){window.setTimeout(a,1E3/60)}}();

    loop();
})

function animation() {
    var animateEl = $('.js-animate');

    if (!animateEl.length) return;

    animateEl.each(function(index, el) {
        var waypoint = new Waypoint({
            element: el,
            handler: function() {
                var element = $(this.element),
                delay = element.attr('data-delay');
                setTimeout(function() {
                    element.addClass('_active');
                }, delay || 0);
                this.destroy();
            },
            offset: '75%'
        });
   });
}animation();

$(function(){
    $('.js-cases-link').on('click', function(){
        $(this).toggleClass('_active');
        $('.js-cases').toggleClass('_active');
    })
})

// $(function(){
//     var contactsMap = $('.js-contacts-map');
//     if (!contactsMap.length) return
//     mapboxgl.accessToken = 'pk.eyJ1IjoibW92aWUtbSIsImEiOiJjanlsbmp6ZTgwOWR6M2xxazlzeW5zNGJzIn0.HSoPlQOE4MJQiNXmsAiwXg';
//     var map = new mapboxgl.Map({
//         container: 'contacts-map',
//         style: 'mapbox://styles/mapbox/light-v10',
//         zoom: 15,
//         center: [37.473167, 55.773907]
//     });
//     var geojson = {
//         "type": "FeatureCollection",
//         "features": [{
//                 "type": "Feature",
//                 "properties": {
//                     "iconSize": [90, 113],
//                     "iconName": "map-icon.svg",
//                     "iconOffset": [-45, -50]
//                 },
//                 "geometry": {
//                     "type": "Point",
//                     "coordinates": [37.473167, 55.772907]
//                 }
//             }
//         ]
//     };
//     geojson.features.forEach(function(marker) {
//         var el = document.createElement('div');
//         el.className = 'map__marker';
//         el.style.backgroundImage = 'url(img/' + marker.properties.iconName + ')';
//         el.style.width = marker.properties.iconSize[0] + 'px';
//         el.style.height = marker.properties.iconSize[1] + 'px';
//         el.style.marginTop = marker.properties.iconOffset[0] + 'px';
//         el.style.marginleft = marker.properties.iconOffset[1] + 'px';
//
//         new mapboxgl.Marker(el)
//             .setLngLat(marker.geometry.coordinates)
//             .addTo(map);
//     });
// })

$(function(){
    var jsDiagram = $('.js-diagram');
    if (!jsDiagram.length) return;

    var thisPath = $('.js-diagram-path').attr('d');
    var newPath = $('.js-diagram').data('path');
    var newFill = $('.js-diagram').data('fill');
    var s = Snap(document.querySelector('.js-diagram-svg'));
	var path = s.select('.js-diagram-path');
	var initialPath = path.attr('d');
    var startTime = 500
    function doneAnim(){
        path.animate({
            'path': newPath
        }, startTime, mina.ease);
        path.animate({
            'fill': newFill
        }, 10, mina.ease);
    }
    setTimeout(function(){
        doneAnim()
    }, 600)
})

$(function(){
    var homeSlider = $('.js-home-slider');
    if (!homeSlider.length) return;
    var homeSliderSwiper = new Swiper('.js-home-slider', {
        navigation: {
            nextEl: '.js-home-slider-next'
        },
        effect: 'fade',
        speed: 1000,
        pagination: {
            el: '.js-home-slider-pagination',
            type: 'progressbar'
        }
    });
})

// function initialise() {
//     var styles = [{
//             "featureType": "all",
//             "elementType": "geometry.fill",
//             "stylers": [{
//                 "weight": "2.00"
//             }]
//         },
//         {
//             "featureType": "all",
//             "elementType": "geometry.stroke",
//             "stylers": [{
//                 "color": "#9c9c9c"
//             }]
//         },
//         {
//             "featureType": "all",
//             "elementType": "labels.text",
//             "stylers": [{
//                 "visibility": "on"
//             }]
//         },
//         {
//             "featureType": "administrative.land_parcel",
//             "elementType": "geometry.fill",
//             "stylers": [{
//                     "visibility": "on"
//                 },
//                 {
//                     "color": "#372305"
//                 },
//                 {
//                     "saturation": "-25"
//                 }
//             ]
//         },
//         {
//             "featureType": "landscape",
//             "elementType": "all",
//             "stylers": [{
//                 "color": "#f2f2f2"
//             }]
//         },
//         {
//             "featureType": "landscape",
//             "elementType": "geometry.fill",
//             "stylers": [{
//                 "color": "#ffffff"
//             }]
//         },
//         {
//             "featureType": "landscape.man_made",
//             "elementType": "geometry.fill",
//             "stylers": [{
//                 "color": "#ffffff"
//             }]
//         },
//         {
//             "featureType": "poi",
//             "elementType": "all",
//             "stylers": [{
//                 "visibility": "off"
//             }]
//         },
//         {
//             "featureType": "road",
//             "elementType": "all",
//             "stylers": [{
//                     "saturation": -100
//                 },
//                 {
//                     "lightness": 45
//                 }
//             ]
//         },
//         {
//             "featureType": "road",
//             "elementType": "geometry.fill",
//             "stylers": [{
//                 "color": "#eeeeee"
//             }]
//         },
//         {
//             "featureType": "road",
//             "elementType": "labels.text.fill",
//             "stylers": [{
//                 "color": "#7b7b7b"
//             }]
//         },
//         {
//             "featureType": "road",
//             "elementType": "labels.text.stroke",
//             "stylers": [{
//                 "color": "#ffffff"
//             }]
//         },
//         {
//             "featureType": "road.highway",
//             "elementType": "all",
//             "stylers": [{
//                 "visibility": "simplified"
//             }]
//         },
//         {
//             "featureType": "road.arterial",
//             "elementType": "labels.icon",
//             "stylers": [{
//                 "visibility": "off"
//             }]
//         },
//         {
//             "featureType": "transit",
//             "elementType": "all",
//             "stylers": [{
//                 "visibility": "off"
//             }]
//         },
//         {
//             "featureType": "water",
//             "elementType": "all",
//             "stylers": [{
//                     "color": "#46bcec"
//                 },
//                 {
//                     "visibility": "on"
//                 }
//             ]
//         },
//         {
//             "featureType": "water",
//             "elementType": "geometry.fill",
//             "stylers": [{
//                 "color": "#c8d7d4"
//             }]
//         },
//         {
//             "featureType": "water",
//             "elementType": "labels.text.fill",
//             "stylers": [{
//                 "color": "#070707"
//             }]
//         },
//         {
//             "featureType": "water",
//             "elementType": "labels.text.stroke",
//             "stylers": [{
//                 "color": "#ffffff"
//             }]
//         }
//     ];
//     var mapOptions = {
//         zoom: 13,
//         disableDefaultUI: true,
//         disableDoubleClickZoom: true,
//         scrollwheel: false,
//         styles: styles
//     }
//     var data = {
//         x: $("#contacts-map").data('x'),
//         y: $("#contacts-map").data('y'),
//     }
//     var map = new google.maps.Map($("#contacts-map")[0], mapOptions);
//     var w = $(window).width();
//     map.setCenter({
//         lat: data.x,
//         lng: data.y
//     });
//     var marker = new google.maps.Marker({
//         position: new google.maps.LatLng(data.x, data.y),
//         map: map,
//         icon: 'images/marker.svg'
//     });
// };
// google.maps.event.addDomListener(window, 'load', initialise);

$(function(){

if($('#contacts-map').length){ 
  var positionMarkerX = $("#contacts-map").data('x'),
      positionMarkerY = $("#contacts-map").data('y');
      ymaps.ready(function () {
      var myMap = new ymaps.Map('contacts-map', {
            center: [positionMarkerX, positionMarkerY],
            zoom: 13,controls: []
        }, {
              searchControlProvider: 'yandex#search'
          }),

     

          myPlacemarkWithContent = new ymaps.Placemark([positionMarkerX, positionMarkerY], {
              // hintContent: 'Собственный значок метки с контентом',
              // balloonContent: 'А эта — новогодняя',
              // iconContent: '12'
          }, {
              // Опции.
              // Необходимо указать данный тип макета.
              iconLayout: 'default#imageWithContent',
              // Своё изображение иконки метки.
              iconImageHref: 'images/marker.svg',
              // Размеры метки.
              iconImageSize: [130, 163],
              // Смещение левого верхнего угла иконки относительно
              // её "ножки" (точки привязки).
              iconImageOffset: [-65, -80],
              // Смещение слоя с содержимым относительно слоя с картинкой.
              // iconContentOffset: [15, 15],
              // // Макет содержимого.
              // iconContentLayout: MyIconContentLayout
          }); 
          // myMap.controls.remove('searchControl');

          myMap.geoObjects
              .add(myPlacemarkWithContent);
        });
        // var GM = {
        //     init: function () {
        //         this.initCache();
        //         this.initMap();
        //     },

        //     initCache: function() {
        //         this.$body         = $('body');
        //     },


        //     initMap: function () {
        //         var positionMarkerX = $('#map').data('x'),
        //             positionMarkerY = $('#map').data('y'),
        //             coordinates = {lat: positionMarkerX, lng: positionMarkerY},
        //             positionMarker = {lat: positionMarkerX, lng: positionMarkerY},
        //             markerImage = 'images/marker.svg',
        //             zoom = 16,

        //             map = new google.maps.Map(document.getElementById('map'), {
        //                 center: coordinates,
        //                 zoom: zoom,
        //                 disableDefaultUI: true,
        //                 scrollwheel: true,
        //                 zoomControl: true, 
        //                 zoomControlOptions: {
        //                    style: google.maps.ZoomControlStyle.LARGE,
        //                    position: google.maps.ControlPosition.CENTER_RIGHT
        //                 }
        //             }),


        //             marker = new google.maps.Marker({
        //                 position: positionMarker,
        //                 map: map,
        //                 icon: markerImage
        //             });

        //         $.getJSON("json/google-custom.json", function (data) {
        //             map.setOptions({styles: data});
        //         });

        //     }
        // };

        // $(document).ready(function() {
        //     GM.init();
        // });
    }    


    var menuCases = $('.js-menu-cases');
    if (!menuCases.length) return;
    var menuCasesSwiper = new Swiper('.js-menu-cases', {
        speed: 500,
        direction: 'vertical',
        centeredSlides: true,
        slidesPerView: 9,
        calculateHeight: true,
        loop: true,
        slideToClickedSlide: true,
        loopAdditionalSlides: 20,
        loopedSlides: 20,
        breakpoints: {
            360: {
                slidesPerView: 8
            }
        }
    });
    $(document).on('click', '.js-cases-link', function(){
        setTimeout(function(){
            menuCasesSwiper.update(true);
            $('.js-cases').addClass('_open')
        }, 500)
    })
})

$(function(){
    var display = false;
    $('.js-menu-link').on('click', function(){
        if (!display) {
            $('body').addClass('_noscroll');
            $(this).addClass('_active');
            $('.js-menu').addClass('_active');
            display = true;
        } else {
            $('.js-menu-link').removeClass('_active');
            $('.js-menu').removeClass('_active');
            $('.js-cases').removeClass('_active _open');
            $('body').removeClass('_noscroll');
            display = false;
        }
    })
})

$(function(){
    $('.js-modal-link').on('click', function(){
        var id = $(this).data('link');
        $('.js-modal-overlay').addClass('_active');
        $(id).addClass('_active');
        $('body').addClass('_modal');
    })
    $('.js-modal-close').on('click', function(){
        $('body').removeClass('_modal');
        $('.js-modal-overlay').removeClass('_active');
        $('.js-modal').removeClass('_active');
    })
})

$(function(){
    var slider = $('.js-slider-easy');
    if (!slider.length) return;
    var sliderSwiper = new Swiper('.js-slider-easy', {
        navigation: {
            prevEl: '.js-slider-easy-prev',
            nextEl: '.js-slider-easy-next'
        },
        speed: 500
    });
})

$(function(){
    $('.js-social-link').on('click', function(){
        $(this).toggleClass('_active');
        $('.js-social-box').toggleClass('_active');
        $('.js-logo-box').toggleClass('_active');
    })
})

$(function(){
    var jsWave = $('.js-wave');
    if (!jsWave.length) return;

    var thisPath = $('.js-wave-path').attr('d');
    var newPath = $('.js-wave').data('last-path');
    var middlePath = $('.js-wave').data('middle-path');
    var s = Snap(document.querySelector('.js-wave-svg'));
	var path = s.select('.js-wave-path');
	var initialPath = path.attr('d');
    var startTime = 2300
    function doneAnim(){
        path.animate({'path': newPath}, startTime, mina.ease);
        intervalTime = startTime*3
        setTimeout(function(){
            path.animate({'path': middlePath}, startTime, mina.ease);
        }, startTime)
        setTimeout(function(){
            path.animate({'path': thisPath}, startTime, mina.ease);
        }, startTime*2)
    }doneAnim()
    setInterval(function(){
        doneAnim()
    }, startTime*3)
})
