<?php $__env->startSection('page-title', $title); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <?php echo $__env->make('core::common.breadcrumb', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="portlet light ">
        <div class="portlet-title">
            <div class="caption font-red-intense">
                <i class="icon-pin font-red-intense"></i>
                <span class="caption-subject bold uppercase"><?php echo e($title); ?></span>
            </div>

            <div class="actions btn-set">
                <a href="<?php echo e(action($controller.'@create')); ?>" class="btn btn-default"> Добавить</a>
                <a href="<?php echo e(action($controller.'@index')); ?>" class="btn btn-default"> К списку</a>
            </div>
        </div>

        <div class="portlet-body form">

            <div class="tabbable-line">
                <ul class="nav nav-tabs ">
                    <li class="active">
                        <a href="#tab_1" data-toggle="tab">Общее</a>
                    </li>
                    <?php if(!(isset($item->short) && $item->short)): ?>
                    <li>
                        <a href="#tab_blocks" data-toggle="tab">Описание</a>
                    </li>
                    <?php endif; ?>
                </ul>

                <div class="tab-content">
                    <div class="tab-pane active" id="tab_1">

                        <?php echo form_start($form, ['class'=>'form-horizontal form-bordered form-label-stripped']); ?>

                        <?php echo form_rest($form); ?>

                        <div class="form-actions">
                            <div class="row">
                                <div class="col-md-offset-3 col-md-9">
                                    <button type="submit" class="btn purple"><i class="fa fa-check"></i> Сохранить </button>
                                    <button type="button" class="btn default" onclick="document.location = '<?php echo e(action($controller.'@index')); ?>'">Отмена</button>
                                </div>
                            </div>
                        </div>

                        <?php echo form_end($form); ?>

                    </div>

                    <?php if(!(isset($item->short) && $item->short)): ?>
                    <div class="tab-pane" id="tab_blocks">
                        <div class="clearfix">
                            <a href="<?php echo e(route(strtolower(class_basename($item)).'s.blocks.create', ['item' => $item->id])); ?>" class="btn btn-default pull-right"> Добавить блок</a>
                        </div><br/>

                        <?php if($item->blocks->isNotEmpty()): ?>
                            <table class="table table-striped table-bordered table-hover" >
                                <thead>
                                <tr role="row" class="heading">
                                    <th width="1%">
                                        ID
                                    </th>
                                    <th width="1%">
                                        Поз.
                                    </th>
                                    <th>Название</th>
                                    <th>Тип</th>
                                    <th>Включено</th>

                                    <th width="1%">
                                        <?=_('Действия')?>
                                    </th>
                                </tr>
                                </thead>
                                <tbody>

                                <?php $__currentLoopData = $item->blocks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $block): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr align="center" class="odd">
                                        <td style="font-size:11px;color:#999;"><?php echo e($block->id); ?></td>
                                        <td class="item" id="<?php echo e($block->pos); ?>" style="font-size:11px;color:#999;">
                                            <input class="inp" id="<?php echo e($block->id); ?>" style="width:40px; display:none; font-size:11px; text-align:center;" type="text" value="<?php echo e($block->pos); ?>" rel="<?php echo e($block->getTable()); ?>" cat="" cat_val="" />
                                            <span style="display:block; width:40px;"><?php echo e($block->pos); ?></span></td>
                                        <td align="left"><?php echo e($block->title); ?></td>
                                        <td align="left"><?php echo e(\Modules\Main\Entities\Block::$types[$block->type]); ?></td>
                                        <td align="left"><?php echo e($block->act ? 'Да' : 'Нет'); ?></td>
                                        <td nowrap="nowrap">
                                            <a class="btn btn-icon-only blue" href="<?php echo e(route(strtolower(class_basename($item)).'s.blocks.edit', ['case' => $item->id, 'block' => $block->id])); ?>" title="<?=_('Редактировать')?>"><i class="fa fa-pencil"></i></a>
                                            <form id="del-form-<?php echo e($block->id); ?>" action="<?php echo e(route(strtolower(class_basename($item)).'s.blocks.destroy', ['case' => $item->id, 'block' => $block->id])); ?>" method="POST" style="display: none;">
                                                <?php echo e(csrf_field()); ?>

                                                <?php echo e(method_field('DELETE')); ?>

                                            </form>
                                            <a href="javascript:del('del-form-<?php echo e($block->id); ?>')" title="<?=_('Удалить')?>" class="btn btn-icon-only red"><i class="fa fa-trash-o"></i></a>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                </tbody>
                            </table>
                        <?php endif; ?>
                    </div>
                    <?php endif; ?>

                </div>
            </div>


        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php $__env->startPush('scripts'); ?>
    <script src="/admin_assets/js/sort.js" type="text/javascript"></script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('core::layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/new-test.movie-group.ru/Modules/Main/Providers/../Resources/views/cases/edit.blade.php ENDPATH**/ ?>