<?php
/**
 * @var $page[]
 */
?>


<?php $__env->startSection('page-title',  $page['seo_title'] ? $page['seo_title'] : $page['title']); ?>
<?php $__env->startSection('keywords',    $page['seo_keywords']); ?>
<?php $__env->startSection('description', $page['seo_description']); ?>

<?php $__env->startSection('content'); ?>

    <main class="page__main">
        <div class="about">
            <div class="about__img js-animate">
                <img src="<?php echo e(getImagePath($page['image'], 600, 700, 'crop')); ?>" alt="">
                <div class="about__info">
                    <div class="about__inner inner">
                        <div class="about__title"><?php echo e($page['title']); ?></div>
                        <div class="about__desc">
                            <?php echo e($page['sub_title']); ?>

                        </div>
                    </div>
                </div>
            </div>
            <div class="about-header js-animate">
                <div class="about-header__inner inner">
                    <div class="about-header__desc">
                        <p><?php echo nl2br($page['text']); ?></p>
                    </div>
                    <div class="about-header__index">
                        <p><?php echo nl2br($page['blockquote']); ?></p>
                    </div>
                </div>
                <canvas id="c-wave" class="about-header__wave"></canvas>
            </div>
            <div class="about-stat">
                <div class="about-stat__inner inner">
                    <div class="about-stat__title">
                        MOVIE В ЦИФРАХ
                    </div>
                    <div class="about-stat__list">
                        <div class="about-stat__box js-animate">
                            <div class="about-stat-item _type-1">
                                <img class="about-stat-item__img" src="/mobile/img/circle-n.svg" alt="">
                                <div class="about-stat-item__wrap">
                                    <div class="about-stat-item__title">
                                        <?php echo $page['numbers_main']; ?>

                                    </div>
                                    <div class="about-stat-item__desc">
                                        <p><?php echo nl2br($page['numbers_main_caption']); ?></p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="about-stat__box js-animate">
                            <div class="about-stat-item _type-2">
                                <img class="about-stat-item__img" src="/mobile/img/about-type-2.svg" alt="">
                                <div class="about-stat-item__wrap">
                                    <div class="about-stat-item__title">
                                        <big><?php echo e($page['numbers_n1']); ?></big>
                                    </div>
                                    <div class="about-stat-item__desc">
                                        <p><?php echo nl2br($page['numbers_n1_caption']); ?></p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="about-stat__box js-animate">
                            <div class="about-stat-item _type-2">
                                <img class="about-stat-item__img" src="/mobile/img/about-type-3.svg" alt="">
                                <div class="about-stat-item__wrap">
                                    <div class="about-stat-item__title">
                                        <big><?php echo e($page['numbers_n2']); ?></big>
                                    </div>
                                    <div class="about-stat-item__desc">
                                        <p><?php echo nl2br($page['numbers_n2_caption']); ?></p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="about-stat__box js-animate">
                            <div class="about-stat-item _type-2">
                                <img class="about-stat-item__img" src="/mobile/img/about-type-4.svg" alt="">
                                <div class="about-stat-item__wrap">
                                    <div class="about-stat-item__title">
                                        <big><?php echo e($page['numbers_n3']); ?></big>
                                    </div>
                                    <div class="about-stat-item__desc">
                                        <p><?php echo nl2br($page['numbers_n3_caption']); ?></p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </main>

<?php $__env->stopSection(); ?>
	

<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/new-test.movie-group.ru/resources/mobile/about.blade.php ENDPATH**/ ?>