<?php
/**
 * @var $article \Modules\Main\Entities\CCase
*/
?>


<?php $__env->startSection('page-title',  $article->title); ?>
<?php $__env->startSection('keywords',    ''); ?>
<?php $__env->startSection('description', ''); ?>

<?php $__env->startSection('content'); ?>

    <main class="page__main">
        <div class="page__content">
            <div class="page__inner inner">
                <div class="page__back back">
                    <a href="/news/" class="back__link">НАЗАД</a>
                </div>
                <div class="post">
                    <div class="post__img">
                        <img src="<?php echo e(getImagePath($article->image, 450, 400, 'crop')); ?>" alt="">
                        <div class="post__status">
                            <?php if(!$article->short && $article->sticker): ?>
                                <img src="/images/general/<?php echo e($article->sticker); ?>.svg" style="max-height: 110px; width: auto" alt="">
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="typography">
                        <span class="name">
                            <?php echo e(date('d.m.Y', strtotime($article->date))); ?>

                        </span>
                        <h2><?php echo e($article->title); ?></h2>
                        <?php echo $article->content ?: $article->anons; ?>

                    </div>
                    <?php if($article->short && $article->link): ?>
                    <div class="post__link">
                        <a href="<?php echo e($article->link); ?>" rel="nofollow" target="_blank"><?php echo e($article->link); ?></a>
                    </div>
                    <?php endif; ?>
                    <?php if(!$article->short && $article->blocks->isNotEmpty()): ?>

                        <?php if($article->main_image): ?>
                            <div class="post-img">
                                <img src="<?php echo e(getImagePath($article->main_image, 450, 200, 'crop')); ?>" alt="">
                            </div>
                            <br/>
                        <?php endif; ?>

                        <?php $__currentLoopData = $article->blocks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $block): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                            <?php switch($block->type):

                                case (\Modules\Main\Entities\Block::TYPE_SIMPLE_TEXT): ?>

                                <div class="typography">
                                    <h2><?php echo e($block->title); ?></h2>
                                    <p><?php echo $block->content1; ?></p>
                                </div>

                                <?php break; ?>

                                <?php case (\Modules\Main\Entities\Block::TYPE_TASK_DECISION): ?>
                                <div class="typography">
                                    <span class="name">ЗАДАЧА:</span>
                                    <?php echo $block->content1; ?>

                                </div>
                                <div class="typography">
                                    <span class="name">РЕШЕНИЕ:</span>
                                    <h2><?php echo e($block->title); ?></h2>
                                    <?php echo $block->content2; ?>

                                </div>
                                <?php break; ?>

                                <?php case (\Modules\Main\Entities\Block::TYPE_RESULT): ?>
                                <div class="typography">
                                    <span class="name">РЕЗУЛЬТАТ:</span>
                                    <h2><?php echo e($block->title); ?></h2>
                                    <p><?php echo $block->content1; ?></p>
                                </div>
                                <?php break; ?>

                                <?php case (\Modules\Main\Entities\Block::TYPE_GALLERY): ?>
                                <div class="post-slider">
                                    <div class="post-slider__container js-slider-easy swiper-container">
                                        <div class="post-slider__wrapper swiper-wrapper">
                                            <?php $__currentLoopData = $block->images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <div class="post-slider__box swiper-slide">
                                                    <div class="post-slider__item">
                                                        <img src="<?php echo e(getImagePath($image->image, 400, 300, 'crop')); ?>" alt="">
                                                    </div>
                                                </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>
                                        <div class="post-slider__arrow">
                                            <button type="button" class="post-slider__arrow-item _prev js-slider-easy-prev"></button>
                                            <button type="button" class="post-slider__arrow-item _next js-slider-easy-next"></button>
                                        </div>
                                    </div>
                                </div>

                                <?php break; ?>

                                <?php case (\Modules\Main\Entities\Block::TYPE_VIDEO): ?>
                                <div class="post-video">
                                    <a href="<?php echo e($block->video); ?>" data-fancybox="video" class="post-video__link">
                                        <?php if($block->image): ?>
                                            <img src="<?php echo e(getImagePath($block->image)); ?>" alt="">
                                        <?php endif; ?>
                                    </a>
                                </div>
                                <?php break; ?>

                            <?php endswitch; ?>

                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    <?php endif; ?>

                </div>

                <div class="c-nav">
                    <div class="c-nav__inner">
                        <div class="c-nav__wrapper">
                            <div class="c-nav__box">
                                <?php if($article->previous()): ?>
                                    <a href="<?php echo e(route('news.show', ['slug' => $article->previous()->slug])); ?>" class="c-nav__link _prev">ПРЕДЫДУЩАЯ НОВОСТЬ</a>
                                <?php endif; ?>
                            </div>
                            <div class="c-nav__box">
                                <?php if($article->next()): ?>
                                    <a href="<?php echo e(route('news.show', ['slug' => $article->next()->slug])); ?>" class="c-nav__link _next">СЛЕДУЮЩАЯ НОВОСТЬ</a>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
                
            </div>
        </div>
    </main>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/new-test.movie-group.ru/resources/mobile/news_one.blade.php ENDPATH**/ ?>